/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.azurestackhci.vm.AzureStackHciVmManager;
import com.azure.resourcemanager.azurestackhci.vm.fluent.SecurityRulesClient;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.SecurityRuleInner;
import com.azure.resourcemanager.azurestackhci.vm.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.azurestackhci.vm.implementation.SecurityRuleImpl;
import com.azure.resourcemanager.azurestackhci.vm.models.SecurityRule;
import com.azure.resourcemanager.azurestackhci.vm.models.SecurityRules;

public final class SecurityRulesImpl
implements SecurityRules {
    private static final ClientLogger LOGGER = new ClientLogger(SecurityRulesImpl.class);
    private final SecurityRulesClient innerClient;
    private final AzureStackHciVmManager serviceManager;

    public SecurityRulesImpl(SecurityRulesClient innerClient, AzureStackHciVmManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<SecurityRule> getWithResponse(String resourceGroupName, String networkSecurityGroupName, String securityRuleName, Context context) {
        Response<SecurityRuleInner> inner = this.serviceClient().getWithResponse(resourceGroupName, networkSecurityGroupName, securityRuleName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SecurityRuleImpl((SecurityRuleInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SecurityRule get(String resourceGroupName, String networkSecurityGroupName, String securityRuleName) {
        SecurityRuleInner inner = this.serviceClient().get(resourceGroupName, networkSecurityGroupName, securityRuleName);
        if (inner != null) {
            return new SecurityRuleImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String networkSecurityGroupName, String securityRuleName) {
        this.serviceClient().delete(resourceGroupName, networkSecurityGroupName, securityRuleName);
    }

    @Override
    public void delete(String resourceGroupName, String networkSecurityGroupName, String securityRuleName, Context context) {
        this.serviceClient().delete(resourceGroupName, networkSecurityGroupName, securityRuleName, context);
    }

    @Override
    public PagedIterable<SecurityRule> listByNetworkSecurityGroup(String resourceGroupName, String networkSecurityGroupName) {
        PagedIterable<SecurityRuleInner> inner = this.serviceClient().listByNetworkSecurityGroup(resourceGroupName, networkSecurityGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SecurityRuleImpl((SecurityRuleInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SecurityRule> listByNetworkSecurityGroup(String resourceGroupName, String networkSecurityGroupName, Context context) {
        PagedIterable<SecurityRuleInner> inner = this.serviceClient().listByNetworkSecurityGroup(resourceGroupName, networkSecurityGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SecurityRuleImpl((SecurityRuleInner)((Object)inner1), this.manager()));
    }

    @Override
    public SecurityRule getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String networkSecurityGroupName = ResourceManagerUtils.getValueFromIdByName(id, "networkSecurityGroups");
        if (networkSecurityGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'networkSecurityGroups'.", id)));
        }
        String securityRuleName = ResourceManagerUtils.getValueFromIdByName(id, "securityRules");
        if (securityRuleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'securityRules'.", id)));
        }
        return (SecurityRule)this.getWithResponse(resourceGroupName, networkSecurityGroupName, securityRuleName, Context.NONE).getValue();
    }

    @Override
    public Response<SecurityRule> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String networkSecurityGroupName = ResourceManagerUtils.getValueFromIdByName(id, "networkSecurityGroups");
        if (networkSecurityGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'networkSecurityGroups'.", id)));
        }
        String securityRuleName = ResourceManagerUtils.getValueFromIdByName(id, "securityRules");
        if (securityRuleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'securityRules'.", id)));
        }
        return this.getWithResponse(resourceGroupName, networkSecurityGroupName, securityRuleName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String networkSecurityGroupName = ResourceManagerUtils.getValueFromIdByName(id, "networkSecurityGroups");
        if (networkSecurityGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'networkSecurityGroups'.", id)));
        }
        String securityRuleName = ResourceManagerUtils.getValueFromIdByName(id, "securityRules");
        if (securityRuleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'securityRules'.", id)));
        }
        this.delete(resourceGroupName, networkSecurityGroupName, securityRuleName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String networkSecurityGroupName = ResourceManagerUtils.getValueFromIdByName(id, "networkSecurityGroups");
        if (networkSecurityGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'networkSecurityGroups'.", id)));
        }
        String securityRuleName = ResourceManagerUtils.getValueFromIdByName(id, "securityRules");
        if (securityRuleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'securityRules'.", id)));
        }
        this.delete(resourceGroupName, networkSecurityGroupName, securityRuleName, context);
    }

    private SecurityRulesClient serviceClient() {
        return this.innerClient;
    }

    private AzureStackHciVmManager manager() {
        return this.serviceManager;
    }

    @Override
    public SecurityRuleImpl define(String name) {
        return new SecurityRuleImpl(name, this.manager());
    }
}

