/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.azurestackhci.vm.AzureStackHciVmManager;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.SecurityRuleInner;
import com.azure.resourcemanager.azurestackhci.vm.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.azurestackhci.vm.models.ExtendedLocation;
import com.azure.resourcemanager.azurestackhci.vm.models.SecurityRule;
import com.azure.resourcemanager.azurestackhci.vm.models.SecurityRuleProperties;

public final class SecurityRuleImpl
implements SecurityRule,
SecurityRule.Definition,
SecurityRule.Update {
    private SecurityRuleInner innerObject;
    private final AzureStackHciVmManager serviceManager;
    private String resourceGroupName;
    private String networkSecurityGroupName;
    private String securityRuleName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SecurityRuleProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public SecurityRuleInner innerModel() {
        return this.innerObject;
    }

    private AzureStackHciVmManager manager() {
        return this.serviceManager;
    }

    @Override
    public SecurityRuleImpl withExistingNetworkSecurityGroup(String resourceGroupName, String networkSecurityGroupName) {
        this.resourceGroupName = resourceGroupName;
        this.networkSecurityGroupName = networkSecurityGroupName;
        return this;
    }

    @Override
    public SecurityRule create() {
        this.innerObject = this.serviceManager.serviceClient().getSecurityRules().createOrUpdate(this.resourceGroupName, this.networkSecurityGroupName, this.securityRuleName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public SecurityRule create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSecurityRules().createOrUpdate(this.resourceGroupName, this.networkSecurityGroupName, this.securityRuleName, this.innerModel(), context);
        return this;
    }

    SecurityRuleImpl(String name, AzureStackHciVmManager serviceManager) {
        this.innerObject = new SecurityRuleInner();
        this.serviceManager = serviceManager;
        this.securityRuleName = name;
    }

    @Override
    public SecurityRuleImpl update() {
        return this;
    }

    @Override
    public SecurityRule apply() {
        this.innerObject = this.serviceManager.serviceClient().getSecurityRules().createOrUpdate(this.resourceGroupName, this.networkSecurityGroupName, this.securityRuleName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public SecurityRule apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSecurityRules().createOrUpdate(this.resourceGroupName, this.networkSecurityGroupName, this.securityRuleName, this.innerModel(), context);
        return this;
    }

    SecurityRuleImpl(SecurityRuleInner innerObject, AzureStackHciVmManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.networkSecurityGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "networkSecurityGroups");
        this.securityRuleName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "securityRules");
    }

    @Override
    public SecurityRule refresh() {
        this.innerObject = (SecurityRuleInner)((Object)this.serviceManager.serviceClient().getSecurityRules().getWithResponse(this.resourceGroupName, this.networkSecurityGroupName, this.securityRuleName, Context.NONE).getValue());
        return this;
    }

    @Override
    public SecurityRule refresh(Context context) {
        this.innerObject = (SecurityRuleInner)((Object)this.serviceManager.serviceClient().getSecurityRules().getWithResponse(this.resourceGroupName, this.networkSecurityGroupName, this.securityRuleName, context).getValue());
        return this;
    }

    @Override
    public SecurityRuleImpl withProperties(SecurityRuleProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public SecurityRuleImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }
}

