/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.azurestackhci.vm.AzureStackHciVmManager;
import com.azure.resourcemanager.azurestackhci.vm.fluent.NetworkSecurityGroupsClient;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.NetworkSecurityGroupInner;
import com.azure.resourcemanager.azurestackhci.vm.implementation.NetworkSecurityGroupImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.azurestackhci.vm.models.NetworkSecurityGroup;
import com.azure.resourcemanager.azurestackhci.vm.models.NetworkSecurityGroups;

public final class NetworkSecurityGroupsImpl
implements NetworkSecurityGroups {
    private static final ClientLogger LOGGER = new ClientLogger(NetworkSecurityGroupsImpl.class);
    private final NetworkSecurityGroupsClient innerClient;
    private final AzureStackHciVmManager serviceManager;

    public NetworkSecurityGroupsImpl(NetworkSecurityGroupsClient innerClient, AzureStackHciVmManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<NetworkSecurityGroup> getByResourceGroupWithResponse(String resourceGroupName, String networkSecurityGroupName, Context context) {
        Response<NetworkSecurityGroupInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, networkSecurityGroupName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new NetworkSecurityGroupImpl((NetworkSecurityGroupInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public NetworkSecurityGroup getByResourceGroup(String resourceGroupName, String networkSecurityGroupName) {
        NetworkSecurityGroupInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, networkSecurityGroupName);
        if (inner != null) {
            return new NetworkSecurityGroupImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String networkSecurityGroupName) {
        this.serviceClient().delete(resourceGroupName, networkSecurityGroupName);
    }

    @Override
    public void delete(String resourceGroupName, String networkSecurityGroupName, Context context) {
        this.serviceClient().delete(resourceGroupName, networkSecurityGroupName, context);
    }

    @Override
    public PagedIterable<NetworkSecurityGroup> listByResourceGroup(String resourceGroupName) {
        PagedIterable<NetworkSecurityGroupInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NetworkSecurityGroupImpl((NetworkSecurityGroupInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<NetworkSecurityGroup> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<NetworkSecurityGroupInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NetworkSecurityGroupImpl((NetworkSecurityGroupInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<NetworkSecurityGroup> list() {
        PagedIterable<NetworkSecurityGroupInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NetworkSecurityGroupImpl((NetworkSecurityGroupInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<NetworkSecurityGroup> list(Context context) {
        PagedIterable<NetworkSecurityGroupInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NetworkSecurityGroupImpl((NetworkSecurityGroupInner)((Object)inner1), this.manager()));
    }

    @Override
    public NetworkSecurityGroup getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String networkSecurityGroupName = ResourceManagerUtils.getValueFromIdByName(id, "networkSecurityGroups");
        if (networkSecurityGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'networkSecurityGroups'.", id)));
        }
        return (NetworkSecurityGroup)this.getByResourceGroupWithResponse(resourceGroupName, networkSecurityGroupName, Context.NONE).getValue();
    }

    @Override
    public Response<NetworkSecurityGroup> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String networkSecurityGroupName = ResourceManagerUtils.getValueFromIdByName(id, "networkSecurityGroups");
        if (networkSecurityGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'networkSecurityGroups'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, networkSecurityGroupName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String networkSecurityGroupName = ResourceManagerUtils.getValueFromIdByName(id, "networkSecurityGroups");
        if (networkSecurityGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'networkSecurityGroups'.", id)));
        }
        this.delete(resourceGroupName, networkSecurityGroupName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String networkSecurityGroupName = ResourceManagerUtils.getValueFromIdByName(id, "networkSecurityGroups");
        if (networkSecurityGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'networkSecurityGroups'.", id)));
        }
        this.delete(resourceGroupName, networkSecurityGroupName, context);
    }

    private NetworkSecurityGroupsClient serviceClient() {
        return this.innerClient;
    }

    private AzureStackHciVmManager manager() {
        return this.serviceManager;
    }

    @Override
    public NetworkSecurityGroupImpl define(String name) {
        return new NetworkSecurityGroupImpl(name, this.manager());
    }
}

