/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.azurestackhci.vm.AzureStackHciVmManager;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.NetworkSecurityGroupInner;
import com.azure.resourcemanager.azurestackhci.vm.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.azurestackhci.vm.models.ExtendedLocation;
import com.azure.resourcemanager.azurestackhci.vm.models.NetworkSecurityGroup;
import com.azure.resourcemanager.azurestackhci.vm.models.NetworkSecurityGroupProperties;
import com.azure.resourcemanager.azurestackhci.vm.models.NetworkSecurityGroupTagsUpdate;
import java.util.Collections;
import java.util.Map;

public final class NetworkSecurityGroupImpl
implements NetworkSecurityGroup,
NetworkSecurityGroup.Definition,
NetworkSecurityGroup.Update {
    private NetworkSecurityGroupInner innerObject;
    private final AzureStackHciVmManager serviceManager;
    private String resourceGroupName;
    private String networkSecurityGroupName;
    private NetworkSecurityGroupTagsUpdate updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public NetworkSecurityGroupProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public String eTag() {
        return this.innerModel().eTag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public NetworkSecurityGroupInner innerModel() {
        return this.innerObject;
    }

    private AzureStackHciVmManager manager() {
        return this.serviceManager;
    }

    @Override
    public NetworkSecurityGroupImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public NetworkSecurityGroup create() {
        this.innerObject = this.serviceManager.serviceClient().getNetworkSecurityGroups().createOrUpdate(this.resourceGroupName, this.networkSecurityGroupName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public NetworkSecurityGroup create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getNetworkSecurityGroups().createOrUpdate(this.resourceGroupName, this.networkSecurityGroupName, this.innerModel(), context);
        return this;
    }

    NetworkSecurityGroupImpl(String name, AzureStackHciVmManager serviceManager) {
        this.innerObject = new NetworkSecurityGroupInner();
        this.serviceManager = serviceManager;
        this.networkSecurityGroupName = name;
    }

    @Override
    public NetworkSecurityGroupImpl update() {
        this.updateProperties = new NetworkSecurityGroupTagsUpdate();
        return this;
    }

    @Override
    public NetworkSecurityGroup apply() {
        this.innerObject = this.serviceManager.serviceClient().getNetworkSecurityGroups().updateTags(this.resourceGroupName, this.networkSecurityGroupName, this.updateProperties, Context.NONE);
        return this;
    }

    @Override
    public NetworkSecurityGroup apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getNetworkSecurityGroups().updateTags(this.resourceGroupName, this.networkSecurityGroupName, this.updateProperties, context);
        return this;
    }

    NetworkSecurityGroupImpl(NetworkSecurityGroupInner innerObject, AzureStackHciVmManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.networkSecurityGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "networkSecurityGroups");
    }

    @Override
    public NetworkSecurityGroup refresh() {
        this.innerObject = (NetworkSecurityGroupInner)((Object)this.serviceManager.serviceClient().getNetworkSecurityGroups().getByResourceGroupWithResponse(this.resourceGroupName, this.networkSecurityGroupName, Context.NONE).getValue());
        return this;
    }

    @Override
    public NetworkSecurityGroup refresh(Context context) {
        this.innerObject = (NetworkSecurityGroupInner)((Object)this.serviceManager.serviceClient().getNetworkSecurityGroups().getByResourceGroupWithResponse(this.resourceGroupName, this.networkSecurityGroupName, context).getValue());
        return this;
    }

    @Override
    public NetworkSecurityGroupImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public NetworkSecurityGroupImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public NetworkSecurityGroupImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateProperties.withTags(tags);
        return this;
    }

    @Override
    public NetworkSecurityGroupImpl withProperties(NetworkSecurityGroupProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public NetworkSecurityGroupImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

