/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.azurestackhci.vm.AzureStackHciVmManager;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.NetworkInterfaceInner;
import com.azure.resourcemanager.azurestackhci.vm.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.azurestackhci.vm.models.ExtendedLocation;
import com.azure.resourcemanager.azurestackhci.vm.models.NetworkInterface;
import com.azure.resourcemanager.azurestackhci.vm.models.NetworkInterfaceProperties;
import com.azure.resourcemanager.azurestackhci.vm.models.NetworkInterfacesUpdateProperties;
import com.azure.resourcemanager.azurestackhci.vm.models.NetworkInterfacesUpdateRequest;
import java.util.Collections;
import java.util.Map;

public final class NetworkInterfaceImpl
implements NetworkInterface,
NetworkInterface.Definition,
NetworkInterface.Update {
    private NetworkInterfaceInner innerObject;
    private final AzureStackHciVmManager serviceManager;
    private String resourceGroupName;
    private String networkInterfaceName;
    private NetworkInterfacesUpdateRequest updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public NetworkInterfaceProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public NetworkInterfaceInner innerModel() {
        return this.innerObject;
    }

    private AzureStackHciVmManager manager() {
        return this.serviceManager;
    }

    @Override
    public NetworkInterfaceImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public NetworkInterface create() {
        this.innerObject = this.serviceManager.serviceClient().getNetworkInterfaces().createOrUpdate(this.resourceGroupName, this.networkInterfaceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public NetworkInterface create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getNetworkInterfaces().createOrUpdate(this.resourceGroupName, this.networkInterfaceName, this.innerModel(), context);
        return this;
    }

    NetworkInterfaceImpl(String name, AzureStackHciVmManager serviceManager) {
        this.innerObject = new NetworkInterfaceInner();
        this.serviceManager = serviceManager;
        this.networkInterfaceName = name;
    }

    @Override
    public NetworkInterfaceImpl update() {
        this.updateProperties = new NetworkInterfacesUpdateRequest();
        return this;
    }

    @Override
    public NetworkInterface apply() {
        this.innerObject = this.serviceManager.serviceClient().getNetworkInterfaces().update(this.resourceGroupName, this.networkInterfaceName, this.updateProperties, Context.NONE);
        return this;
    }

    @Override
    public NetworkInterface apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getNetworkInterfaces().update(this.resourceGroupName, this.networkInterfaceName, this.updateProperties, context);
        return this;
    }

    NetworkInterfaceImpl(NetworkInterfaceInner innerObject, AzureStackHciVmManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.networkInterfaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "networkInterfaces");
    }

    @Override
    public NetworkInterface refresh() {
        this.innerObject = (NetworkInterfaceInner)((Object)this.serviceManager.serviceClient().getNetworkInterfaces().getByResourceGroupWithResponse(this.resourceGroupName, this.networkInterfaceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public NetworkInterface refresh(Context context) {
        this.innerObject = (NetworkInterfaceInner)((Object)this.serviceManager.serviceClient().getNetworkInterfaces().getByResourceGroupWithResponse(this.resourceGroupName, this.networkInterfaceName, context).getValue());
        return this;
    }

    @Override
    public NetworkInterfaceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public NetworkInterfaceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateProperties.withTags(tags);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withProperties(NetworkInterfaceProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withProperties(NetworkInterfacesUpdateProperties properties) {
        this.updateProperties.withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

