/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.azurestackhci.vm.AzureStackHciVmManager;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.LogicalNetworkInner;
import com.azure.resourcemanager.azurestackhci.vm.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.azurestackhci.vm.models.ExtendedLocation;
import com.azure.resourcemanager.azurestackhci.vm.models.LogicalNetwork;
import com.azure.resourcemanager.azurestackhci.vm.models.LogicalNetworkProperties;
import com.azure.resourcemanager.azurestackhci.vm.models.LogicalNetworksUpdateRequest;
import java.util.Collections;
import java.util.Map;

public final class LogicalNetworkImpl
implements LogicalNetwork,
LogicalNetwork.Definition,
LogicalNetwork.Update {
    private LogicalNetworkInner innerObject;
    private final AzureStackHciVmManager serviceManager;
    private String resourceGroupName;
    private String logicalNetworkName;
    private LogicalNetworksUpdateRequest updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public LogicalNetworkProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public LogicalNetworkInner innerModel() {
        return this.innerObject;
    }

    private AzureStackHciVmManager manager() {
        return this.serviceManager;
    }

    @Override
    public LogicalNetworkImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public LogicalNetwork create() {
        this.innerObject = this.serviceManager.serviceClient().getLogicalNetworks().createOrUpdate(this.resourceGroupName, this.logicalNetworkName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public LogicalNetwork create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getLogicalNetworks().createOrUpdate(this.resourceGroupName, this.logicalNetworkName, this.innerModel(), context);
        return this;
    }

    LogicalNetworkImpl(String name, AzureStackHciVmManager serviceManager) {
        this.innerObject = new LogicalNetworkInner();
        this.serviceManager = serviceManager;
        this.logicalNetworkName = name;
    }

    @Override
    public LogicalNetworkImpl update() {
        this.updateProperties = new LogicalNetworksUpdateRequest();
        return this;
    }

    @Override
    public LogicalNetwork apply() {
        this.innerObject = this.serviceManager.serviceClient().getLogicalNetworks().update(this.resourceGroupName, this.logicalNetworkName, this.updateProperties, Context.NONE);
        return this;
    }

    @Override
    public LogicalNetwork apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getLogicalNetworks().update(this.resourceGroupName, this.logicalNetworkName, this.updateProperties, context);
        return this;
    }

    LogicalNetworkImpl(LogicalNetworkInner innerObject, AzureStackHciVmManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.logicalNetworkName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "logicalNetworks");
    }

    @Override
    public LogicalNetwork refresh() {
        this.innerObject = (LogicalNetworkInner)((Object)this.serviceManager.serviceClient().getLogicalNetworks().getByResourceGroupWithResponse(this.resourceGroupName, this.logicalNetworkName, Context.NONE).getValue());
        return this;
    }

    @Override
    public LogicalNetwork refresh(Context context) {
        this.innerObject = (LogicalNetworkInner)((Object)this.serviceManager.serviceClient().getLogicalNetworks().getByResourceGroupWithResponse(this.resourceGroupName, this.logicalNetworkName, context).getValue());
        return this;
    }

    @Override
    public LogicalNetworkImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public LogicalNetworkImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public LogicalNetworkImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateProperties.withTags(tags);
        return this;
    }

    @Override
    public LogicalNetworkImpl withProperties(LogicalNetworkProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public LogicalNetworkImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

