/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.azurestackhci.vm.AzureStackHciVmManager;
import com.azure.resourcemanager.azurestackhci.vm.fluent.HybridIdentityMetadatasClient;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.HybridIdentityMetadataInner;
import com.azure.resourcemanager.azurestackhci.vm.implementation.HybridIdentityMetadataImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.azurestackhci.vm.models.HybridIdentityMetadata;
import com.azure.resourcemanager.azurestackhci.vm.models.HybridIdentityMetadatas;

public final class HybridIdentityMetadatasImpl
implements HybridIdentityMetadatas {
    private static final ClientLogger LOGGER = new ClientLogger(HybridIdentityMetadatasImpl.class);
    private final HybridIdentityMetadatasClient innerClient;
    private final AzureStackHciVmManager serviceManager;

    public HybridIdentityMetadatasImpl(HybridIdentityMetadatasClient innerClient, AzureStackHciVmManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<HybridIdentityMetadata> getWithResponse(String resourceUri, Context context) {
        Response<HybridIdentityMetadataInner> inner = this.serviceClient().getWithResponse(resourceUri, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new HybridIdentityMetadataImpl((HybridIdentityMetadataInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public HybridIdentityMetadata get(String resourceUri) {
        HybridIdentityMetadataInner inner = this.serviceClient().get(resourceUri);
        if (inner != null) {
            return new HybridIdentityMetadataImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<HybridIdentityMetadata> listByVirtualMachineInstance(String resourceUri) {
        PagedIterable<HybridIdentityMetadataInner> inner = this.serviceClient().listByVirtualMachineInstance(resourceUri);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new HybridIdentityMetadataImpl((HybridIdentityMetadataInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<HybridIdentityMetadata> listByVirtualMachineInstance(String resourceUri, Context context) {
        PagedIterable<HybridIdentityMetadataInner> inner = this.serviceClient().listByVirtualMachineInstance(resourceUri, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new HybridIdentityMetadataImpl((HybridIdentityMetadataInner)((Object)inner1), this.manager()));
    }

    private HybridIdentityMetadatasClient serviceClient() {
        return this.innerClient;
    }

    private AzureStackHciVmManager manager() {
        return this.serviceManager;
    }
}

