/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.azurestackhci.vm.fluent.HybridIdentityMetadatasClient;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.HybridIdentityMetadataInner;
import com.azure.resourcemanager.azurestackhci.vm.implementation.AzureStackHciVmMgmtClientImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.models.HybridIdentityMetadataListResult;
import reactor.core.publisher.Mono;

public final class HybridIdentityMetadatasClientImpl
implements HybridIdentityMetadatasClient {
    private final HybridIdentityMetadatasService service;
    private final AzureStackHciVmMgmtClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(HybridIdentityMetadatasClientImpl.class);

    HybridIdentityMetadatasClientImpl(AzureStackHciVmMgmtClientImpl client) {
        this.service = (HybridIdentityMetadatasService)RestProxy.create(HybridIdentityMetadatasService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<HybridIdentityMetadataInner>> getWithResponseAsync(String resourceUri) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), resourceUri, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<HybridIdentityMetadataInner> getAsync(String resourceUri) {
        return this.getWithResponseAsync(resourceUri).flatMap(res -> Mono.justOrEmpty((Object)((Object)((HybridIdentityMetadataInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<HybridIdentityMetadataInner> getWithResponse(String resourceUri, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), resourceUri, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public HybridIdentityMetadataInner get(String resourceUri) {
        return (HybridIdentityMetadataInner)((Object)this.getWithResponse(resourceUri, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<HybridIdentityMetadataInner>> listByVirtualMachineInstanceSinglePageAsync(String resourceUri) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByVirtualMachineInstance(this.client.getEndpoint(), this.client.getApiVersion(), resourceUri, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((HybridIdentityMetadataListResult)res.getValue()).value(), ((HybridIdentityMetadataListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<HybridIdentityMetadataInner> listByVirtualMachineInstanceAsync(String resourceUri) {
        return new PagedFlux(() -> this.listByVirtualMachineInstanceSinglePageAsync(resourceUri), nextLink -> this.listByVirtualMachineInstanceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<HybridIdentityMetadataInner> listByVirtualMachineInstanceSinglePage(String resourceUri) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String accept = "application/json";
        Response<HybridIdentityMetadataListResult> res = this.service.listByVirtualMachineInstanceSync(this.client.getEndpoint(), this.client.getApiVersion(), resourceUri, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((HybridIdentityMetadataListResult)res.getValue()).value(), ((HybridIdentityMetadataListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<HybridIdentityMetadataInner> listByVirtualMachineInstanceSinglePage(String resourceUri, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String accept = "application/json";
        Response<HybridIdentityMetadataListResult> res = this.service.listByVirtualMachineInstanceSync(this.client.getEndpoint(), this.client.getApiVersion(), resourceUri, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((HybridIdentityMetadataListResult)res.getValue()).value(), ((HybridIdentityMetadataListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<HybridIdentityMetadataInner> listByVirtualMachineInstance(String resourceUri) {
        return new PagedIterable(() -> this.listByVirtualMachineInstanceSinglePage(resourceUri), nextLink -> this.listByVirtualMachineInstanceNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<HybridIdentityMetadataInner> listByVirtualMachineInstance(String resourceUri, Context context) {
        return new PagedIterable(() -> this.listByVirtualMachineInstanceSinglePage(resourceUri, context), nextLink -> this.listByVirtualMachineInstanceNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<HybridIdentityMetadataInner>> listByVirtualMachineInstanceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByVirtualMachineInstanceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((HybridIdentityMetadataListResult)res.getValue()).value(), ((HybridIdentityMetadataListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<HybridIdentityMetadataInner> listByVirtualMachineInstanceNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<HybridIdentityMetadataListResult> res = this.service.listByVirtualMachineInstanceNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((HybridIdentityMetadataListResult)res.getValue()).value(), ((HybridIdentityMetadataListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<HybridIdentityMetadataInner> listByVirtualMachineInstanceNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<HybridIdentityMetadataListResult> res = this.service.listByVirtualMachineInstanceNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((HybridIdentityMetadataListResult)res.getValue()).value(), ((HybridIdentityMetadataListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="AzureStackHciVmMgmtClientHybridIdentityMetadatas")
    public static interface HybridIdentityMetadatasService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceUri}/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default/hybridIdentityMetadata/default")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<HybridIdentityMetadataInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceUri", encoded=true) String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceUri}/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default/hybridIdentityMetadata/default")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<HybridIdentityMetadataInner> getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceUri", encoded=true) String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceUri}/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default/hybridIdentityMetadata")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<HybridIdentityMetadataListResult>> listByVirtualMachineInstance(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceUri", encoded=true) String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceUri}/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default/hybridIdentityMetadata")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<HybridIdentityMetadataListResult> listByVirtualMachineInstanceSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceUri", encoded=true) String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<HybridIdentityMetadataListResult>> listByVirtualMachineInstanceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<HybridIdentityMetadataListResult> listByVirtualMachineInstanceNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

