/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.azurestackhci.vm.AzureStackHciVmManager;
import com.azure.resourcemanager.azurestackhci.vm.fluent.GuestAgentsClient;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.GuestAgentInner;
import com.azure.resourcemanager.azurestackhci.vm.implementation.GuestAgentImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.azurestackhci.vm.models.GuestAgent;
import com.azure.resourcemanager.azurestackhci.vm.models.GuestAgents;

public final class GuestAgentsImpl
implements GuestAgents {
    private static final ClientLogger LOGGER = new ClientLogger(GuestAgentsImpl.class);
    private final GuestAgentsClient innerClient;
    private final AzureStackHciVmManager serviceManager;

    public GuestAgentsImpl(GuestAgentsClient innerClient, AzureStackHciVmManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<GuestAgent> getWithResponse(String resourceUri, Context context) {
        Response<GuestAgentInner> inner = this.serviceClient().getWithResponse(resourceUri, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GuestAgentImpl((GuestAgentInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public GuestAgent get(String resourceUri) {
        GuestAgentInner inner = this.serviceClient().get(resourceUri);
        if (inner != null) {
            return new GuestAgentImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public GuestAgent create(String resourceUri, GuestAgentInner resource) {
        GuestAgentInner inner = this.serviceClient().create(resourceUri, resource);
        if (inner != null) {
            return new GuestAgentImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public GuestAgent create(String resourceUri, GuestAgentInner resource, Context context) {
        GuestAgentInner inner = this.serviceClient().create(resourceUri, resource, context);
        if (inner != null) {
            return new GuestAgentImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceUri) {
        this.serviceClient().delete(resourceUri);
    }

    @Override
    public void delete(String resourceUri, Context context) {
        this.serviceClient().delete(resourceUri, context);
    }

    @Override
    public PagedIterable<GuestAgent> listByVirtualMachineInstance(String resourceUri) {
        PagedIterable<GuestAgentInner> inner = this.serviceClient().listByVirtualMachineInstance(resourceUri);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GuestAgentImpl((GuestAgentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<GuestAgent> listByVirtualMachineInstance(String resourceUri, Context context) {
        PagedIterable<GuestAgentInner> inner = this.serviceClient().listByVirtualMachineInstance(resourceUri, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GuestAgentImpl((GuestAgentInner)((Object)inner1), this.manager()));
    }

    private GuestAgentsClient serviceClient() {
        return this.innerClient;
    }

    private AzureStackHciVmManager manager() {
        return this.serviceManager;
    }
}

