/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.azurestackhci.vm.fluent.GuestAgentsClient;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.GuestAgentInner;
import com.azure.resourcemanager.azurestackhci.vm.implementation.AzureStackHciVmMgmtClientImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.models.GuestAgentListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class GuestAgentsClientImpl
implements GuestAgentsClient {
    private final GuestAgentsService service;
    private final AzureStackHciVmMgmtClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(GuestAgentsClientImpl.class);

    GuestAgentsClientImpl(AzureStackHciVmMgmtClientImpl client) {
        this.service = (GuestAgentsService)RestProxy.create(GuestAgentsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GuestAgentInner>> getWithResponseAsync(String resourceUri) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), resourceUri, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GuestAgentInner> getAsync(String resourceUri) {
        return this.getWithResponseAsync(resourceUri).flatMap(res -> Mono.justOrEmpty((Object)((Object)((GuestAgentInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GuestAgentInner> getWithResponse(String resourceUri, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), resourceUri, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GuestAgentInner get(String resourceUri) {
        return (GuestAgentInner)((Object)this.getWithResponse(resourceUri, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceUri, GuestAgentInner resource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        if (resource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getApiVersion(), resourceUri, "application/json", "application/json", resource, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createWithResponse(String resourceUri, GuestAgentInner resource) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        if (resource == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createSync(this.client.getEndpoint(), this.client.getApiVersion(), resourceUri, "application/json", "application/json", resource, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createWithResponse(String resourceUri, GuestAgentInner resource, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        if (resource == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createSync(this.client.getEndpoint(), this.client.getApiVersion(), resourceUri, "application/json", "application/json", resource, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<GuestAgentInner>, GuestAgentInner> beginCreateAsync(String resourceUri, GuestAgentInner resource) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceUri, resource);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)GuestAgentInner.class), (Type)((Object)GuestAgentInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GuestAgentInner>, GuestAgentInner> beginCreate(String resourceUri, GuestAgentInner resource) {
        Response<BinaryData> response = this.createWithResponse(resourceUri, resource);
        return this.client.getLroResult(response, (Type)((Object)GuestAgentInner.class), (Type)((Object)GuestAgentInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GuestAgentInner>, GuestAgentInner> beginCreate(String resourceUri, GuestAgentInner resource, Context context) {
        Response<BinaryData> response = this.createWithResponse(resourceUri, resource, context);
        return this.client.getLroResult(response, (Type)((Object)GuestAgentInner.class), (Type)((Object)GuestAgentInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GuestAgentInner> createAsync(String resourceUri, GuestAgentInner resource) {
        return this.beginCreateAsync(resourceUri, resource).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GuestAgentInner create(String resourceUri, GuestAgentInner resource) {
        return (GuestAgentInner)((Object)this.beginCreate(resourceUri, resource).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GuestAgentInner create(String resourceUri, GuestAgentInner resource, Context context) {
        return (GuestAgentInner)((Object)this.beginCreate(resourceUri, resource, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceUri) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), resourceUri, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceUri) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), resourceUri, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceUri, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), resourceUri, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceUri) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceUri);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceUri) {
        Response<BinaryData> response = this.deleteWithResponse(resourceUri);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceUri, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceUri, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceUri) {
        return this.beginDeleteAsync(resourceUri).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceUri) {
        this.beginDelete(resourceUri).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceUri, Context context) {
        this.beginDelete(resourceUri, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GuestAgentInner>> listByVirtualMachineInstanceSinglePageAsync(String resourceUri) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByVirtualMachineInstance(this.client.getEndpoint(), this.client.getApiVersion(), resourceUri, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GuestAgentListResult)res.getValue()).value(), ((GuestAgentListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<GuestAgentInner> listByVirtualMachineInstanceAsync(String resourceUri) {
        return new PagedFlux(() -> this.listByVirtualMachineInstanceSinglePageAsync(resourceUri), nextLink -> this.listByVirtualMachineInstanceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<GuestAgentInner> listByVirtualMachineInstanceSinglePage(String resourceUri) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String accept = "application/json";
        Response<GuestAgentListResult> res = this.service.listByVirtualMachineInstanceSync(this.client.getEndpoint(), this.client.getApiVersion(), resourceUri, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GuestAgentListResult)res.getValue()).value(), ((GuestAgentListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<GuestAgentInner> listByVirtualMachineInstanceSinglePage(String resourceUri, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String accept = "application/json";
        Response<GuestAgentListResult> res = this.service.listByVirtualMachineInstanceSync(this.client.getEndpoint(), this.client.getApiVersion(), resourceUri, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GuestAgentListResult)res.getValue()).value(), ((GuestAgentListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GuestAgentInner> listByVirtualMachineInstance(String resourceUri) {
        return new PagedIterable(() -> this.listByVirtualMachineInstanceSinglePage(resourceUri), nextLink -> this.listByVirtualMachineInstanceNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GuestAgentInner> listByVirtualMachineInstance(String resourceUri, Context context) {
        return new PagedIterable(() -> this.listByVirtualMachineInstanceSinglePage(resourceUri, context), nextLink -> this.listByVirtualMachineInstanceNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GuestAgentInner>> listByVirtualMachineInstanceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByVirtualMachineInstanceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GuestAgentListResult)res.getValue()).value(), ((GuestAgentListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<GuestAgentInner> listByVirtualMachineInstanceNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<GuestAgentListResult> res = this.service.listByVirtualMachineInstanceNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GuestAgentListResult)res.getValue()).value(), ((GuestAgentListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<GuestAgentInner> listByVirtualMachineInstanceNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<GuestAgentListResult> res = this.service.listByVirtualMachineInstanceNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GuestAgentListResult)res.getValue()).value(), ((GuestAgentListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="AzureStackHciVmMgmtClientGuestAgents")
    public static interface GuestAgentsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceUri}/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default/guestAgents/default")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GuestAgentInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceUri", encoded=true) String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceUri}/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default/guestAgents/default")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<GuestAgentInner> getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceUri", encoded=true) String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Put(value="/{resourceUri}/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default/guestAgents/default")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceUri", encoded=true) String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") GuestAgentInner var6, Context var7);

        @Put(value="/{resourceUri}/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default/guestAgents/default")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceUri", encoded=true) String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") GuestAgentInner var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/{resourceUri}/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default/guestAgents/default")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceUri", encoded=true) String var3, Context var4);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/{resourceUri}/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default/guestAgents/default")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceUri", encoded=true) String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceUri}/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default/guestAgents")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GuestAgentListResult>> listByVirtualMachineInstance(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceUri", encoded=true) String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceUri}/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default/guestAgents")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<GuestAgentListResult> listByVirtualMachineInstanceSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceUri", encoded=true) String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GuestAgentListResult>> listByVirtualMachineInstanceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<GuestAgentListResult> listByVirtualMachineInstanceNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

