/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.azurestackhci.vm.AzureStackHciVmManager;
import com.azure.resourcemanager.azurestackhci.vm.fluent.GalleryImagesClient;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.GalleryImageInner;
import com.azure.resourcemanager.azurestackhci.vm.implementation.GalleryImageImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.azurestackhci.vm.models.GalleryImage;
import com.azure.resourcemanager.azurestackhci.vm.models.GalleryImages;

public final class GalleryImagesImpl
implements GalleryImages {
    private static final ClientLogger LOGGER = new ClientLogger(GalleryImagesImpl.class);
    private final GalleryImagesClient innerClient;
    private final AzureStackHciVmManager serviceManager;

    public GalleryImagesImpl(GalleryImagesClient innerClient, AzureStackHciVmManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<GalleryImage> getByResourceGroupWithResponse(String resourceGroupName, String galleryImageName, Context context) {
        Response<GalleryImageInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, galleryImageName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GalleryImageImpl((GalleryImageInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public GalleryImage getByResourceGroup(String resourceGroupName, String galleryImageName) {
        GalleryImageInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, galleryImageName);
        if (inner != null) {
            return new GalleryImageImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String galleryImageName) {
        this.serviceClient().delete(resourceGroupName, galleryImageName);
    }

    @Override
    public void delete(String resourceGroupName, String galleryImageName, Context context) {
        this.serviceClient().delete(resourceGroupName, galleryImageName, context);
    }

    @Override
    public PagedIterable<GalleryImage> listByResourceGroup(String resourceGroupName) {
        PagedIterable<GalleryImageInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GalleryImageImpl((GalleryImageInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<GalleryImage> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<GalleryImageInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GalleryImageImpl((GalleryImageInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<GalleryImage> list() {
        PagedIterable<GalleryImageInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GalleryImageImpl((GalleryImageInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<GalleryImage> list(Context context) {
        PagedIterable<GalleryImageInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GalleryImageImpl((GalleryImageInner)((Object)inner1), this.manager()));
    }

    @Override
    public GalleryImage getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String galleryImageName = ResourceManagerUtils.getValueFromIdByName(id, "galleryImages");
        if (galleryImageName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'galleryImages'.", id)));
        }
        return (GalleryImage)this.getByResourceGroupWithResponse(resourceGroupName, galleryImageName, Context.NONE).getValue();
    }

    @Override
    public Response<GalleryImage> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String galleryImageName = ResourceManagerUtils.getValueFromIdByName(id, "galleryImages");
        if (galleryImageName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'galleryImages'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, galleryImageName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String galleryImageName = ResourceManagerUtils.getValueFromIdByName(id, "galleryImages");
        if (galleryImageName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'galleryImages'.", id)));
        }
        this.delete(resourceGroupName, galleryImageName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String galleryImageName = ResourceManagerUtils.getValueFromIdByName(id, "galleryImages");
        if (galleryImageName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'galleryImages'.", id)));
        }
        this.delete(resourceGroupName, galleryImageName, context);
    }

    private GalleryImagesClient serviceClient() {
        return this.innerClient;
    }

    private AzureStackHciVmManager manager() {
        return this.serviceManager;
    }

    @Override
    public GalleryImageImpl define(String name) {
        return new GalleryImageImpl(name, this.manager());
    }
}

