/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.azurestackhci.vm.AzureStackHciVmManager;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.GalleryImageInner;
import com.azure.resourcemanager.azurestackhci.vm.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.azurestackhci.vm.models.ExtendedLocation;
import com.azure.resourcemanager.azurestackhci.vm.models.GalleryImage;
import com.azure.resourcemanager.azurestackhci.vm.models.GalleryImageProperties;
import com.azure.resourcemanager.azurestackhci.vm.models.GalleryImageTagsUpdate;
import java.util.Collections;
import java.util.Map;

public final class GalleryImageImpl
implements GalleryImage,
GalleryImage.Definition,
GalleryImage.Update {
    private GalleryImageInner innerObject;
    private final AzureStackHciVmManager serviceManager;
    private String resourceGroupName;
    private String galleryImageName;
    private GalleryImageTagsUpdate updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public GalleryImageProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public GalleryImageInner innerModel() {
        return this.innerObject;
    }

    private AzureStackHciVmManager manager() {
        return this.serviceManager;
    }

    @Override
    public GalleryImageImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public GalleryImage create() {
        this.innerObject = this.serviceManager.serviceClient().getGalleryImages().createOrUpdate(this.resourceGroupName, this.galleryImageName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public GalleryImage create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getGalleryImages().createOrUpdate(this.resourceGroupName, this.galleryImageName, this.innerModel(), context);
        return this;
    }

    GalleryImageImpl(String name, AzureStackHciVmManager serviceManager) {
        this.innerObject = new GalleryImageInner();
        this.serviceManager = serviceManager;
        this.galleryImageName = name;
    }

    @Override
    public GalleryImageImpl update() {
        this.updateProperties = new GalleryImageTagsUpdate();
        return this;
    }

    @Override
    public GalleryImage apply() {
        this.innerObject = this.serviceManager.serviceClient().getGalleryImages().update(this.resourceGroupName, this.galleryImageName, this.updateProperties, Context.NONE);
        return this;
    }

    @Override
    public GalleryImage apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getGalleryImages().update(this.resourceGroupName, this.galleryImageName, this.updateProperties, context);
        return this;
    }

    GalleryImageImpl(GalleryImageInner innerObject, AzureStackHciVmManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.galleryImageName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "galleryImages");
    }

    @Override
    public GalleryImage refresh() {
        this.innerObject = (GalleryImageInner)((Object)this.serviceManager.serviceClient().getGalleryImages().getByResourceGroupWithResponse(this.resourceGroupName, this.galleryImageName, Context.NONE).getValue());
        return this;
    }

    @Override
    public GalleryImage refresh(Context context) {
        this.innerObject = (GalleryImageInner)((Object)this.serviceManager.serviceClient().getGalleryImages().getByResourceGroupWithResponse(this.resourceGroupName, this.galleryImageName, context).getValue());
        return this;
    }

    @Override
    public GalleryImageImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public GalleryImageImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public GalleryImageImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateProperties.withTags(tags);
        return this;
    }

    @Override
    public GalleryImageImpl withProperties(GalleryImageProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public GalleryImageImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

