/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.management.polling.SyncPollerFactory;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.azurestackhci.vm.fluent.AttestationStatusesClient;
import com.azure.resourcemanager.azurestackhci.vm.fluent.AzureStackHciVmMgmtClient;
import com.azure.resourcemanager.azurestackhci.vm.fluent.GalleryImagesClient;
import com.azure.resourcemanager.azurestackhci.vm.fluent.GuestAgentsClient;
import com.azure.resourcemanager.azurestackhci.vm.fluent.HybridIdentityMetadatasClient;
import com.azure.resourcemanager.azurestackhci.vm.fluent.LogicalNetworksClient;
import com.azure.resourcemanager.azurestackhci.vm.fluent.MarketplaceGalleryImagesClient;
import com.azure.resourcemanager.azurestackhci.vm.fluent.NetworkInterfacesClient;
import com.azure.resourcemanager.azurestackhci.vm.fluent.NetworkSecurityGroupsClient;
import com.azure.resourcemanager.azurestackhci.vm.fluent.SecurityRulesClient;
import com.azure.resourcemanager.azurestackhci.vm.fluent.StorageContainersClient;
import com.azure.resourcemanager.azurestackhci.vm.fluent.VirtualHardDisksClient;
import com.azure.resourcemanager.azurestackhci.vm.fluent.VirtualMachineInstancesClient;
import com.azure.resourcemanager.azurestackhci.vm.implementation.AttestationStatusesClientImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.AzureStackHciVmMgmtClientBuilder;
import com.azure.resourcemanager.azurestackhci.vm.implementation.GalleryImagesClientImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.GuestAgentsClientImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.HybridIdentityMetadatasClientImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.LogicalNetworksClientImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.MarketplaceGalleryImagesClientImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.NetworkInterfacesClientImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.NetworkSecurityGroupsClientImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.SecurityRulesClientImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.StorageContainersClientImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.VirtualHardDisksClientImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.VirtualMachineInstancesClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=AzureStackHciVmMgmtClientBuilder.class)
public final class AzureStackHciVmMgmtClientImpl
implements AzureStackHciVmMgmtClient {
    private final String endpoint;
    private final String apiVersion;
    private final String subscriptionId;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final GalleryImagesClient galleryImages;
    private final LogicalNetworksClient logicalNetworks;
    private final MarketplaceGalleryImagesClient marketplaceGalleryImages;
    private final NetworkInterfacesClient networkInterfaces;
    private final NetworkSecurityGroupsClient networkSecurityGroups;
    private final SecurityRulesClient securityRules;
    private final StorageContainersClient storageContainers;
    private final VirtualHardDisksClient virtualHardDisks;
    private final VirtualMachineInstancesClient virtualMachineInstances;
    private final HybridIdentityMetadatasClient hybridIdentityMetadatas;
    private final AttestationStatusesClient attestationStatuses;
    private final GuestAgentsClient guestAgents;
    private static final ClientLogger LOGGER = new ClientLogger(AzureStackHciVmMgmtClientImpl.class);

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public GalleryImagesClient getGalleryImages() {
        return this.galleryImages;
    }

    @Override
    public LogicalNetworksClient getLogicalNetworks() {
        return this.logicalNetworks;
    }

    @Override
    public MarketplaceGalleryImagesClient getMarketplaceGalleryImages() {
        return this.marketplaceGalleryImages;
    }

    @Override
    public NetworkInterfacesClient getNetworkInterfaces() {
        return this.networkInterfaces;
    }

    @Override
    public NetworkSecurityGroupsClient getNetworkSecurityGroups() {
        return this.networkSecurityGroups;
    }

    @Override
    public SecurityRulesClient getSecurityRules() {
        return this.securityRules;
    }

    @Override
    public StorageContainersClient getStorageContainers() {
        return this.storageContainers;
    }

    @Override
    public VirtualHardDisksClient getVirtualHardDisks() {
        return this.virtualHardDisks;
    }

    @Override
    public VirtualMachineInstancesClient getVirtualMachineInstances() {
        return this.virtualMachineInstances;
    }

    @Override
    public HybridIdentityMetadatasClient getHybridIdentityMetadatas() {
        return this.hybridIdentityMetadatas;
    }

    @Override
    public AttestationStatusesClient getAttestationStatuses() {
        return this.attestationStatuses;
    }

    @Override
    public GuestAgentsClient getGuestAgents() {
        return this.guestAgents;
    }

    AzureStackHciVmMgmtClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String endpoint, String subscriptionId) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.endpoint = endpoint;
        this.subscriptionId = subscriptionId;
        this.apiVersion = "2025-06-01-preview";
        this.galleryImages = new GalleryImagesClientImpl(this);
        this.logicalNetworks = new LogicalNetworksClientImpl(this);
        this.marketplaceGalleryImages = new MarketplaceGalleryImagesClientImpl(this);
        this.networkInterfaces = new NetworkInterfacesClientImpl(this);
        this.networkSecurityGroups = new NetworkSecurityGroupsClientImpl(this);
        this.securityRules = new SecurityRulesClientImpl(this);
        this.storageContainers = new StorageContainersClientImpl(this);
        this.virtualHardDisks = new VirtualHardDisksClientImpl(this);
        this.virtualMachineInstances = new VirtualMachineInstancesClientImpl(this);
        this.hybridIdentityMetadatas = new HybridIdentityMetadatasClientImpl(this);
        this.attestationStatuses = new AttestationStatusesClientImpl(this);
        this.guestAgents = new GuestAgentsClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> SyncPoller<PollResult<T>, U> getLroResult(Response<BinaryData> activationResponse, Type pollResultType, Type finalResultType, Context context) {
        return SyncPollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)this.httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, () -> activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(HttpHeaderName.fromString((String)s));
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

