/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.azurestackhci.vm.AzureStackHciVmManager;
import com.azure.resourcemanager.azurestackhci.vm.fluent.AttestationStatusesClient;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.AttestationStatusInner;
import com.azure.resourcemanager.azurestackhci.vm.implementation.AttestationStatusImpl;
import com.azure.resourcemanager.azurestackhci.vm.models.AttestationStatus;
import com.azure.resourcemanager.azurestackhci.vm.models.AttestationStatuses;

public final class AttestationStatusesImpl
implements AttestationStatuses {
    private static final ClientLogger LOGGER = new ClientLogger(AttestationStatusesImpl.class);
    private final AttestationStatusesClient innerClient;
    private final AzureStackHciVmManager serviceManager;

    public AttestationStatusesImpl(AttestationStatusesClient innerClient, AzureStackHciVmManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<AttestationStatus> getWithResponse(String resourceUri, Context context) {
        Response<AttestationStatusInner> inner = this.serviceClient().getWithResponse(resourceUri, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AttestationStatusImpl((AttestationStatusInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AttestationStatus get(String resourceUri) {
        AttestationStatusInner inner = this.serviceClient().get(resourceUri);
        if (inner != null) {
            return new AttestationStatusImpl(inner, this.manager());
        }
        return null;
    }

    private AttestationStatusesClient serviceClient() {
        return this.innerClient;
    }

    private AzureStackHciVmManager manager() {
        return this.serviceManager;
    }
}

