/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.azurestackhci.vm.fluent.AttestationStatusesClient;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.AttestationStatusInner;
import com.azure.resourcemanager.azurestackhci.vm.implementation.AzureStackHciVmMgmtClientImpl;
import reactor.core.publisher.Mono;

public final class AttestationStatusesClientImpl
implements AttestationStatusesClient {
    private final AttestationStatusesService service;
    private final AzureStackHciVmMgmtClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(AttestationStatusesClientImpl.class);

    AttestationStatusesClientImpl(AzureStackHciVmMgmtClientImpl client) {
        this.service = (AttestationStatusesService)RestProxy.create(AttestationStatusesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AttestationStatusInner>> getWithResponseAsync(String resourceUri) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), resourceUri, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AttestationStatusInner> getAsync(String resourceUri) {
        return this.getWithResponseAsync(resourceUri).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AttestationStatusInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AttestationStatusInner> getWithResponse(String resourceUri, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), resourceUri, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AttestationStatusInner get(String resourceUri) {
        return (AttestationStatusInner)((Object)this.getWithResponse(resourceUri, Context.NONE).getValue());
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="AzureStackHciVmMgmtClientAttestationStatuses")
    public static interface AttestationStatusesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceUri}/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default/attestationStatus/default")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AttestationStatusInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceUri", encoded=true) String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceUri}/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default/attestationStatus/default")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AttestationStatusInner> getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceUri", encoded=true) String var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

