/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.IPPool;
import com.azure.resourcemanager.azurestackhci.vm.models.IpAllocationMethodEnum;
import com.azure.resourcemanager.azurestackhci.vm.models.NetworkSecurityGroupArmReference;
import com.azure.resourcemanager.azurestackhci.vm.models.RouteTable;
import com.azure.resourcemanager.azurestackhci.vm.models.SubnetIpConfigurationReference;
import java.io.IOException;
import java.util.List;

public final class SubnetProperties
implements JsonSerializable<SubnetProperties> {
    private String addressPrefix;
    private List<String> addressPrefixes;
    private IpAllocationMethodEnum ipAllocationMethod;
    private List<SubnetIpConfigurationReference> ipConfigurationReferences;
    private NetworkSecurityGroupArmReference networkSecurityGroup;
    private RouteTable routeTable;
    private List<IPPool> ipPools;
    private Integer vlan;

    public String addressPrefix() {
        return this.addressPrefix;
    }

    public SubnetProperties withAddressPrefix(String addressPrefix) {
        this.addressPrefix = addressPrefix;
        return this;
    }

    public List<String> addressPrefixes() {
        return this.addressPrefixes;
    }

    public SubnetProperties withAddressPrefixes(List<String> addressPrefixes) {
        this.addressPrefixes = addressPrefixes;
        return this;
    }

    public IpAllocationMethodEnum ipAllocationMethod() {
        return this.ipAllocationMethod;
    }

    public SubnetProperties withIpAllocationMethod(IpAllocationMethodEnum ipAllocationMethod) {
        this.ipAllocationMethod = ipAllocationMethod;
        return this;
    }

    public List<SubnetIpConfigurationReference> ipConfigurationReferences() {
        return this.ipConfigurationReferences;
    }

    public SubnetProperties withIpConfigurationReferences(List<SubnetIpConfigurationReference> ipConfigurationReferences) {
        this.ipConfigurationReferences = ipConfigurationReferences;
        return this;
    }

    public NetworkSecurityGroupArmReference networkSecurityGroup() {
        return this.networkSecurityGroup;
    }

    public SubnetProperties withNetworkSecurityGroup(NetworkSecurityGroupArmReference networkSecurityGroup) {
        this.networkSecurityGroup = networkSecurityGroup;
        return this;
    }

    public RouteTable routeTable() {
        return this.routeTable;
    }

    public SubnetProperties withRouteTable(RouteTable routeTable) {
        this.routeTable = routeTable;
        return this;
    }

    public List<IPPool> ipPools() {
        return this.ipPools;
    }

    public SubnetProperties withIpPools(List<IPPool> ipPools) {
        this.ipPools = ipPools;
        return this;
    }

    public Integer vlan() {
        return this.vlan;
    }

    public SubnetProperties withVlan(Integer vlan) {
        this.vlan = vlan;
        return this;
    }

    public void validate() {
        if (this.ipConfigurationReferences() != null) {
            this.ipConfigurationReferences().forEach(e -> e.validate());
        }
        if (this.networkSecurityGroup() != null) {
            this.networkSecurityGroup().validate();
        }
        if (this.routeTable() != null) {
            this.routeTable().validate();
        }
        if (this.ipPools() != null) {
            this.ipPools().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("addressPrefix", this.addressPrefix);
        jsonWriter.writeArrayField("addressPrefixes", this.addressPrefixes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("ipAllocationMethod", this.ipAllocationMethod == null ? null : this.ipAllocationMethod.toString());
        jsonWriter.writeArrayField("ipConfigurationReferences", this.ipConfigurationReferences, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("networkSecurityGroup", (JsonSerializable)this.networkSecurityGroup);
        jsonWriter.writeJsonField("routeTable", (JsonSerializable)this.routeTable);
        jsonWriter.writeArrayField("ipPools", this.ipPools, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("vlan", (Number)this.vlan);
        return jsonWriter.writeEndObject();
    }

    public static SubnetProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SubnetProperties)jsonReader.readObject(reader -> {
            SubnetProperties deserializedSubnetProperties = new SubnetProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("addressPrefix".equals(fieldName)) {
                    deserializedSubnetProperties.addressPrefix = reader.getString();
                    continue;
                }
                if ("addressPrefixes".equals(fieldName)) {
                    List addressPrefixes;
                    deserializedSubnetProperties.addressPrefixes = addressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("ipAllocationMethod".equals(fieldName)) {
                    deserializedSubnetProperties.ipAllocationMethod = IpAllocationMethodEnum.fromString(reader.getString());
                    continue;
                }
                if ("ipConfigurationReferences".equals(fieldName)) {
                    List ipConfigurationReferences;
                    deserializedSubnetProperties.ipConfigurationReferences = ipConfigurationReferences = reader.readArray(reader1 -> SubnetIpConfigurationReference.fromJson(reader1));
                    continue;
                }
                if ("networkSecurityGroup".equals(fieldName)) {
                    deserializedSubnetProperties.networkSecurityGroup = NetworkSecurityGroupArmReference.fromJson(reader);
                    continue;
                }
                if ("routeTable".equals(fieldName)) {
                    deserializedSubnetProperties.routeTable = RouteTable.fromJson(reader);
                    continue;
                }
                if ("ipPools".equals(fieldName)) {
                    List ipPools;
                    deserializedSubnetProperties.ipPools = ipPools = reader.readArray(reader1 -> IPPool.fromJson(reader1));
                    continue;
                }
                if ("vlan".equals(fieldName)) {
                    deserializedSubnetProperties.vlan = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSubnetProperties;
        });
    }
}

