/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.ExtendedLocation;
import com.azure.resourcemanager.azurestackhci.vm.models.MarketplaceGalleryImageProperties;
import java.io.IOException;
import java.util.Map;

public final class MarketplaceGalleryImageInner
extends Resource {
    private MarketplaceGalleryImageProperties properties;
    private ExtendedLocation extendedLocation;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public MarketplaceGalleryImageProperties properties() {
        return this.properties;
    }

    public MarketplaceGalleryImageInner withProperties(MarketplaceGalleryImageProperties properties) {
        this.properties = properties;
        return this;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public MarketplaceGalleryImageInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public MarketplaceGalleryImageInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public MarketplaceGalleryImageInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        return jsonWriter.writeEndObject();
    }

    public static MarketplaceGalleryImageInner fromJson(JsonReader jsonReader) throws IOException {
        return (MarketplaceGalleryImageInner)((Object)jsonReader.readObject(reader -> {
            MarketplaceGalleryImageInner deserializedMarketplaceGalleryImageInner = new MarketplaceGalleryImageInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMarketplaceGalleryImageInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMarketplaceGalleryImageInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMarketplaceGalleryImageInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedMarketplaceGalleryImageInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedMarketplaceGalleryImageInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedMarketplaceGalleryImageInner.properties = MarketplaceGalleryImageProperties.fromJson(reader);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedMarketplaceGalleryImageInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedMarketplaceGalleryImageInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMarketplaceGalleryImageInner;
        }));
    }
}

