/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.azurestackhci.vm.fluent.AzureStackHciVmMgmtClient;
import com.azure.resourcemanager.azurestackhci.vm.implementation.AttestationStatusesImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.AzureStackHciVmMgmtClientBuilder;
import com.azure.resourcemanager.azurestackhci.vm.implementation.GalleryImagesImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.GuestAgentsImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.HybridIdentityMetadatasImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.LogicalNetworksImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.MarketplaceGalleryImagesImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.NetworkInterfacesImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.NetworkSecurityGroupsImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.SecurityRulesImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.StorageContainersImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.VirtualHardDisksImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.VirtualMachineInstancesImpl;
import com.azure.resourcemanager.azurestackhci.vm.models.AttestationStatuses;
import com.azure.resourcemanager.azurestackhci.vm.models.GalleryImages;
import com.azure.resourcemanager.azurestackhci.vm.models.GuestAgents;
import com.azure.resourcemanager.azurestackhci.vm.models.HybridIdentityMetadatas;
import com.azure.resourcemanager.azurestackhci.vm.models.LogicalNetworks;
import com.azure.resourcemanager.azurestackhci.vm.models.MarketplaceGalleryImages;
import com.azure.resourcemanager.azurestackhci.vm.models.NetworkInterfaces;
import com.azure.resourcemanager.azurestackhci.vm.models.NetworkSecurityGroups;
import com.azure.resourcemanager.azurestackhci.vm.models.SecurityRules;
import com.azure.resourcemanager.azurestackhci.vm.models.StorageContainers;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualHardDisks;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualMachineInstances;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class AzureStackHciVmManager {
    private GalleryImages galleryImages;
    private LogicalNetworks logicalNetworks;
    private MarketplaceGalleryImages marketplaceGalleryImages;
    private NetworkInterfaces networkInterfaces;
    private NetworkSecurityGroups networkSecurityGroups;
    private SecurityRules securityRules;
    private StorageContainers storageContainers;
    private VirtualHardDisks virtualHardDisks;
    private VirtualMachineInstances virtualMachineInstances;
    private HybridIdentityMetadatas hybridIdentityMetadatas;
    private AttestationStatuses attestationStatuses;
    private GuestAgents guestAgents;
    private final AzureStackHciVmMgmtClient clientObject;

    private AzureStackHciVmManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new AzureStackHciVmMgmtClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static AzureStackHciVmManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return AzureStackHciVmManager.configure().authenticate(credential, profile);
    }

    public static AzureStackHciVmManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new AzureStackHciVmManager(httpPipeline, profile, null);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public GalleryImages galleryImages() {
        if (this.galleryImages == null) {
            this.galleryImages = new GalleryImagesImpl(this.clientObject.getGalleryImages(), this);
        }
        return this.galleryImages;
    }

    public LogicalNetworks logicalNetworks() {
        if (this.logicalNetworks == null) {
            this.logicalNetworks = new LogicalNetworksImpl(this.clientObject.getLogicalNetworks(), this);
        }
        return this.logicalNetworks;
    }

    public MarketplaceGalleryImages marketplaceGalleryImages() {
        if (this.marketplaceGalleryImages == null) {
            this.marketplaceGalleryImages = new MarketplaceGalleryImagesImpl(this.clientObject.getMarketplaceGalleryImages(), this);
        }
        return this.marketplaceGalleryImages;
    }

    public NetworkInterfaces networkInterfaces() {
        if (this.networkInterfaces == null) {
            this.networkInterfaces = new NetworkInterfacesImpl(this.clientObject.getNetworkInterfaces(), this);
        }
        return this.networkInterfaces;
    }

    public NetworkSecurityGroups networkSecurityGroups() {
        if (this.networkSecurityGroups == null) {
            this.networkSecurityGroups = new NetworkSecurityGroupsImpl(this.clientObject.getNetworkSecurityGroups(), this);
        }
        return this.networkSecurityGroups;
    }

    public SecurityRules securityRules() {
        if (this.securityRules == null) {
            this.securityRules = new SecurityRulesImpl(this.clientObject.getSecurityRules(), this);
        }
        return this.securityRules;
    }

    public StorageContainers storageContainers() {
        if (this.storageContainers == null) {
            this.storageContainers = new StorageContainersImpl(this.clientObject.getStorageContainers(), this);
        }
        return this.storageContainers;
    }

    public VirtualHardDisks virtualHardDisks() {
        if (this.virtualHardDisks == null) {
            this.virtualHardDisks = new VirtualHardDisksImpl(this.clientObject.getVirtualHardDisks(), this);
        }
        return this.virtualHardDisks;
    }

    public VirtualMachineInstances virtualMachineInstances() {
        if (this.virtualMachineInstances == null) {
            this.virtualMachineInstances = new VirtualMachineInstancesImpl(this.clientObject.getVirtualMachineInstances(), this);
        }
        return this.virtualMachineInstances;
    }

    public HybridIdentityMetadatas hybridIdentityMetadatas() {
        if (this.hybridIdentityMetadatas == null) {
            this.hybridIdentityMetadatas = new HybridIdentityMetadatasImpl(this.clientObject.getHybridIdentityMetadatas(), this);
        }
        return this.hybridIdentityMetadatas;
    }

    public AttestationStatuses attestationStatuses() {
        if (this.attestationStatuses == null) {
            this.attestationStatuses = new AttestationStatusesImpl(this.clientObject.getAttestationStatuses(), this);
        }
        return this.attestationStatuses;
    }

    public GuestAgents guestAgents() {
        if (this.guestAgents == null) {
            this.guestAgents = new GuestAgentsImpl(this.clientObject.getGuestAgents(), this);
        }
        return this.guestAgents;
    }

    public AzureStackHciVmMgmtClient serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private static final String SDK_VERSION = "version";
        private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-resourcemanager-azurestackhci-vm.properties");
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        public AzureStackHciVmManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            String clientVersion = PROPERTIES.getOrDefault(SDK_VERSION, "UnknownVersion");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.azurestackhci.vm").append("/").append(clientVersion);
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = this.retryOptions != null ? new RetryPolicy(this.retryOptions) : new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new BearerTokenAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new AzureStackHciVmManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

