/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphIdentitySet;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphNotebook;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOnenoteEntityHierarchyModel;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOnenotePage;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphSectionGroup;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphSectionLinks;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphOnenoteSection
extends MicrosoftGraphOnenoteEntityHierarchyModel {
    private Boolean isDefault;
    private MicrosoftGraphSectionLinks links;
    private String pagesUrl;
    private List<MicrosoftGraphOnenotePage> pages;
    private MicrosoftGraphNotebook parentNotebook;
    private MicrosoftGraphSectionGroup parentSectionGroup;
    private Map<String, Object> additionalProperties;

    public Boolean isDefault() {
        return this.isDefault;
    }

    public MicrosoftGraphOnenoteSection withIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    public MicrosoftGraphSectionLinks links() {
        return this.links;
    }

    public MicrosoftGraphOnenoteSection withLinks(MicrosoftGraphSectionLinks links) {
        this.links = links;
        return this;
    }

    public String pagesUrl() {
        return this.pagesUrl;
    }

    public MicrosoftGraphOnenoteSection withPagesUrl(String pagesUrl) {
        this.pagesUrl = pagesUrl;
        return this;
    }

    public List<MicrosoftGraphOnenotePage> pages() {
        return this.pages;
    }

    public MicrosoftGraphOnenoteSection withPages(List<MicrosoftGraphOnenotePage> pages) {
        this.pages = pages;
        return this;
    }

    public MicrosoftGraphNotebook parentNotebook() {
        return this.parentNotebook;
    }

    public MicrosoftGraphOnenoteSection withParentNotebook(MicrosoftGraphNotebook parentNotebook) {
        this.parentNotebook = parentNotebook;
        return this;
    }

    public MicrosoftGraphSectionGroup parentSectionGroup() {
        return this.parentSectionGroup;
    }

    public MicrosoftGraphOnenoteSection withParentSectionGroup(MicrosoftGraphSectionGroup parentSectionGroup) {
        this.parentSectionGroup = parentSectionGroup;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphOnenoteSection withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphOnenoteSection withCreatedBy(MicrosoftGraphIdentitySet createdBy) {
        super.withCreatedBy(createdBy);
        return this;
    }

    @Override
    public MicrosoftGraphOnenoteSection withDisplayName(String displayName) {
        super.withDisplayName(displayName);
        return this;
    }

    @Override
    public MicrosoftGraphOnenoteSection withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    @Override
    public MicrosoftGraphOnenoteSection withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphOnenoteSection withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphOnenoteSection withSelf(String self) {
        super.withSelf(self);
        return this;
    }

    @Override
    public MicrosoftGraphOnenoteSection withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.links() != null) {
            this.links().validate();
        }
        if (this.pages() != null) {
            this.pages().forEach(e -> e.validate());
        }
        if (this.parentNotebook() != null) {
            this.parentNotebook().validate();
        }
        if (this.parentSectionGroup() != null) {
            this.parentSectionGroup().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("self", this.self());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime()));
        jsonWriter.writeJsonField("createdBy", (JsonSerializable)this.createdBy());
        jsonWriter.writeStringField("displayName", this.displayName());
        jsonWriter.writeJsonField("lastModifiedBy", (JsonSerializable)this.lastModifiedBy());
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime()));
        jsonWriter.writeBooleanField("isDefault", this.isDefault);
        jsonWriter.writeJsonField("links", (JsonSerializable)this.links);
        jsonWriter.writeStringField("pagesUrl", this.pagesUrl);
        jsonWriter.writeArrayField("pages", this.pages, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("parentNotebook", (JsonSerializable)this.parentNotebook);
        jsonWriter.writeJsonField("parentSectionGroup", (JsonSerializable)this.parentSectionGroup);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphOnenoteSection fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphOnenoteSection)jsonReader.readObject(reader -> {
            MicrosoftGraphOnenoteSection deserializedMicrosoftGraphOnenoteSection = new MicrosoftGraphOnenoteSection();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteSection.withId(reader.getString());
                    continue;
                }
                if ("self".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteSection.withSelf(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteSection.withCreatedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteSection.withCreatedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteSection.withDisplayName(reader.getString());
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteSection.withLastModifiedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteSection.withLastModifiedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("isDefault".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteSection.isDefault = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("links".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteSection.links = MicrosoftGraphSectionLinks.fromJson(reader);
                    continue;
                }
                if ("pagesUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteSection.pagesUrl = reader.getString();
                    continue;
                }
                if ("pages".equals(fieldName)) {
                    List pages;
                    deserializedMicrosoftGraphOnenoteSection.pages = pages = reader.readArray(reader1 -> MicrosoftGraphOnenotePage.fromJson(reader1));
                    continue;
                }
                if ("parentNotebook".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteSection.parentNotebook = MicrosoftGraphNotebook.fromJson(reader);
                    continue;
                }
                if ("parentSectionGroup".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteSection.parentSectionGroup = MicrosoftGraphSectionGroup.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphOnenoteSection.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphOnenoteSection;
        });
    }
}

