/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public final class MicrosoftGraphAppRoleAssignment
extends MicrosoftGraphDirectoryObjectInner {
    private UUID appRoleId;
    private OffsetDateTime createdDateTime;
    private String principalDisplayName;
    private UUID principalId;
    private String principalType;
    private String resourceDisplayName;
    private UUID resourceId;
    private Map<String, Object> additionalProperties;

    public UUID appRoleId() {
        return this.appRoleId;
    }

    public MicrosoftGraphAppRoleAssignment withAppRoleId(UUID appRoleId) {
        this.appRoleId = appRoleId;
        return this;
    }

    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    public MicrosoftGraphAppRoleAssignment withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    public String principalDisplayName() {
        return this.principalDisplayName;
    }

    public MicrosoftGraphAppRoleAssignment withPrincipalDisplayName(String principalDisplayName) {
        this.principalDisplayName = principalDisplayName;
        return this;
    }

    public UUID principalId() {
        return this.principalId;
    }

    public MicrosoftGraphAppRoleAssignment withPrincipalId(UUID principalId) {
        this.principalId = principalId;
        return this;
    }

    public String principalType() {
        return this.principalType;
    }

    public MicrosoftGraphAppRoleAssignment withPrincipalType(String principalType) {
        this.principalType = principalType;
        return this;
    }

    public String resourceDisplayName() {
        return this.resourceDisplayName;
    }

    public MicrosoftGraphAppRoleAssignment withResourceDisplayName(String resourceDisplayName) {
        this.resourceDisplayName = resourceDisplayName;
        return this;
    }

    public UUID resourceId() {
        return this.resourceId;
    }

    public MicrosoftGraphAppRoleAssignment withResourceId(UUID resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphAppRoleAssignment withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphAppRoleAssignment withDeletedDateTime(OffsetDateTime deletedDateTime) {
        super.withDeletedDateTime(deletedDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphAppRoleAssignment withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("deletedDateTime", this.deletedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.deletedDateTime()));
        jsonWriter.writeStringField("appRoleId", Objects.toString(this.appRoleId, null));
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("principalDisplayName", this.principalDisplayName);
        jsonWriter.writeStringField("principalId", Objects.toString(this.principalId, null));
        jsonWriter.writeStringField("principalType", this.principalType);
        jsonWriter.writeStringField("resourceDisplayName", this.resourceDisplayName);
        jsonWriter.writeStringField("resourceId", Objects.toString(this.resourceId, null));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphAppRoleAssignment fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphAppRoleAssignment)jsonReader.readObject(reader -> {
            MicrosoftGraphAppRoleAssignment deserializedMicrosoftGraphAppRoleAssignment = new MicrosoftGraphAppRoleAssignment();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphAppRoleAssignment.withId(reader.getString());
                    continue;
                }
                if ("deletedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphAppRoleAssignment.withDeletedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("appRoleId".equals(fieldName)) {
                    deserializedMicrosoftGraphAppRoleAssignment.appRoleId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphAppRoleAssignment.createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("principalDisplayName".equals(fieldName)) {
                    deserializedMicrosoftGraphAppRoleAssignment.principalDisplayName = reader.getString();
                    continue;
                }
                if ("principalId".equals(fieldName)) {
                    deserializedMicrosoftGraphAppRoleAssignment.principalId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("principalType".equals(fieldName)) {
                    deserializedMicrosoftGraphAppRoleAssignment.principalType = reader.getString();
                    continue;
                }
                if ("resourceDisplayName".equals(fieldName)) {
                    deserializedMicrosoftGraphAppRoleAssignment.resourceDisplayName = reader.getString();
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedMicrosoftGraphAppRoleAssignment.resourceId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphAppRoleAssignment.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphAppRoleAssignment;
        });
    }
}

