/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphManagedAppOperation
extends MicrosoftGraphEntity {
    private String displayName;
    private OffsetDateTime lastModifiedDateTime;
    private String state;
    private String version;
    private Map<String, Object> additionalProperties;

    public String displayName() {
        return this.displayName;
    }

    public MicrosoftGraphManagedAppOperation withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public MicrosoftGraphManagedAppOperation withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    public String state() {
        return this.state;
    }

    public MicrosoftGraphManagedAppOperation withState(String state) {
        this.state = state;
        return this;
    }

    public String version() {
        return this.version;
    }

    public MicrosoftGraphManagedAppOperation withVersion(String version) {
        this.version = version;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphManagedAppOperation withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphManagedAppOperation withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime));
        jsonWriter.writeStringField("state", this.state);
        jsonWriter.writeStringField("version", this.version);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphManagedAppOperation fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphManagedAppOperation)jsonReader.readObject(reader -> {
            MicrosoftGraphManagedAppOperation deserializedMicrosoftGraphManagedAppOperation = new MicrosoftGraphManagedAppOperation();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedAppOperation.withId(reader.getString());
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedAppOperation.displayName = reader.getString();
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedAppOperation.lastModifiedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedAppOperation.state = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedAppOperation.version = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphManagedAppOperation.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphManagedAppOperation;
        });
    }
}

