/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public final class MicrosoftGraphAppRole
implements JsonSerializable<MicrosoftGraphAppRole> {
    private List<String> allowedMemberTypes;
    private String description;
    private String displayName;
    private UUID id;
    private Boolean isEnabled;
    private String origin;
    private String value;
    private Map<String, Object> additionalProperties;

    public List<String> allowedMemberTypes() {
        return this.allowedMemberTypes;
    }

    public MicrosoftGraphAppRole withAllowedMemberTypes(List<String> allowedMemberTypes) {
        this.allowedMemberTypes = allowedMemberTypes;
        return this;
    }

    public String description() {
        return this.description;
    }

    public MicrosoftGraphAppRole withDescription(String description) {
        this.description = description;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public MicrosoftGraphAppRole withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public UUID id() {
        return this.id;
    }

    public MicrosoftGraphAppRole withId(UUID id) {
        this.id = id;
        return this;
    }

    public Boolean isEnabled() {
        return this.isEnabled;
    }

    public MicrosoftGraphAppRole withIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public String origin() {
        return this.origin;
    }

    public MicrosoftGraphAppRole withOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    public String value() {
        return this.value;
    }

    public MicrosoftGraphAppRole withValue(String value) {
        this.value = value;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public MicrosoftGraphAppRole withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("allowedMemberTypes", this.allowedMemberTypes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("id", Objects.toString(this.id, null));
        jsonWriter.writeBooleanField("isEnabled", this.isEnabled);
        jsonWriter.writeStringField("origin", this.origin);
        jsonWriter.writeStringField("value", this.value);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphAppRole fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphAppRole)jsonReader.readObject(reader -> {
            MicrosoftGraphAppRole deserializedMicrosoftGraphAppRole = new MicrosoftGraphAppRole();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("allowedMemberTypes".equals(fieldName)) {
                    List allowedMemberTypes;
                    deserializedMicrosoftGraphAppRole.allowedMemberTypes = allowedMemberTypes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedMicrosoftGraphAppRole.description = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphAppRole.displayName = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphAppRole.id = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("isEnabled".equals(fieldName)) {
                    deserializedMicrosoftGraphAppRole.isEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("origin".equals(fieldName)) {
                    deserializedMicrosoftGraphAppRole.origin = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedMicrosoftGraphAppRole.value = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphAppRole.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphAppRole;
        });
    }
}

