/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphResourceReference;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphResourceVisualization;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphUsageDetails;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphUsedInsight
extends MicrosoftGraphEntity {
    private MicrosoftGraphUsageDetails lastUsed;
    private MicrosoftGraphResourceReference resourceReference;
    private MicrosoftGraphResourceVisualization resourceVisualization;
    private MicrosoftGraphEntity resource;
    private Map<String, Object> additionalProperties;

    public MicrosoftGraphUsageDetails lastUsed() {
        return this.lastUsed;
    }

    public MicrosoftGraphUsedInsight withLastUsed(MicrosoftGraphUsageDetails lastUsed) {
        this.lastUsed = lastUsed;
        return this;
    }

    public MicrosoftGraphResourceReference resourceReference() {
        return this.resourceReference;
    }

    public MicrosoftGraphUsedInsight withResourceReference(MicrosoftGraphResourceReference resourceReference) {
        this.resourceReference = resourceReference;
        return this;
    }

    public MicrosoftGraphResourceVisualization resourceVisualization() {
        return this.resourceVisualization;
    }

    public MicrosoftGraphUsedInsight withResourceVisualization(MicrosoftGraphResourceVisualization resourceVisualization) {
        this.resourceVisualization = resourceVisualization;
        return this;
    }

    public MicrosoftGraphEntity resource() {
        return this.resource;
    }

    public MicrosoftGraphUsedInsight withResource(MicrosoftGraphEntity resource) {
        this.resource = resource;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphUsedInsight withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphUsedInsight withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.lastUsed() != null) {
            this.lastUsed().validate();
        }
        if (this.resourceReference() != null) {
            this.resourceReference().validate();
        }
        if (this.resourceVisualization() != null) {
            this.resourceVisualization().validate();
        }
        if (this.resource() != null) {
            this.resource().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("lastUsed", (JsonSerializable)this.lastUsed);
        jsonWriter.writeJsonField("resourceReference", (JsonSerializable)this.resourceReference);
        jsonWriter.writeJsonField("resourceVisualization", (JsonSerializable)this.resourceVisualization);
        jsonWriter.writeJsonField("resource", (JsonSerializable)this.resource);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphUsedInsight fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphUsedInsight)jsonReader.readObject(reader -> {
            MicrosoftGraphUsedInsight deserializedMicrosoftGraphUsedInsight = new MicrosoftGraphUsedInsight();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphUsedInsight.withId(reader.getString());
                    continue;
                }
                if ("lastUsed".equals(fieldName)) {
                    deserializedMicrosoftGraphUsedInsight.lastUsed = MicrosoftGraphUsageDetails.fromJson(reader);
                    continue;
                }
                if ("resourceReference".equals(fieldName)) {
                    deserializedMicrosoftGraphUsedInsight.resourceReference = MicrosoftGraphResourceReference.fromJson(reader);
                    continue;
                }
                if ("resourceVisualization".equals(fieldName)) {
                    deserializedMicrosoftGraphUsedInsight.resourceVisualization = MicrosoftGraphResourceVisualization.fromJson(reader);
                    continue;
                }
                if ("resource".equals(fieldName)) {
                    deserializedMicrosoftGraphUsedInsight.resource = MicrosoftGraphEntity.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphUsedInsight.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphUsedInsight;
        });
    }
}

