/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphIdentitySet;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPlannerBucket;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPlannerPlanDetails;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPlannerTask;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphPlannerPlan
extends MicrosoftGraphEntity {
    private MicrosoftGraphIdentitySet createdBy;
    private OffsetDateTime createdDateTime;
    private String owner;
    private String title;
    private List<MicrosoftGraphPlannerBucket> buckets;
    private MicrosoftGraphPlannerPlanDetails details;
    private List<MicrosoftGraphPlannerTask> tasks;
    private Map<String, Object> additionalProperties;

    public MicrosoftGraphIdentitySet createdBy() {
        return this.createdBy;
    }

    public MicrosoftGraphPlannerPlan withCreatedBy(MicrosoftGraphIdentitySet createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    public MicrosoftGraphPlannerPlan withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    public String owner() {
        return this.owner;
    }

    public MicrosoftGraphPlannerPlan withOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public String title() {
        return this.title;
    }

    public MicrosoftGraphPlannerPlan withTitle(String title) {
        this.title = title;
        return this;
    }

    public List<MicrosoftGraphPlannerBucket> buckets() {
        return this.buckets;
    }

    public MicrosoftGraphPlannerPlan withBuckets(List<MicrosoftGraphPlannerBucket> buckets) {
        this.buckets = buckets;
        return this;
    }

    public MicrosoftGraphPlannerPlanDetails details() {
        return this.details;
    }

    public MicrosoftGraphPlannerPlan withDetails(MicrosoftGraphPlannerPlanDetails details) {
        this.details = details;
        return this;
    }

    public List<MicrosoftGraphPlannerTask> tasks() {
        return this.tasks;
    }

    public MicrosoftGraphPlannerPlan withTasks(List<MicrosoftGraphPlannerTask> tasks) {
        this.tasks = tasks;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphPlannerPlan withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphPlannerPlan withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.createdBy() != null) {
            this.createdBy().validate();
        }
        if (this.buckets() != null) {
            this.buckets().forEach(e -> e.validate());
        }
        if (this.details() != null) {
            this.details().validate();
        }
        if (this.tasks() != null) {
            this.tasks().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("createdBy", (JsonSerializable)this.createdBy);
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("owner", this.owner);
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeArrayField("buckets", this.buckets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("details", (JsonSerializable)this.details);
        jsonWriter.writeArrayField("tasks", this.tasks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphPlannerPlan fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphPlannerPlan)jsonReader.readObject(reader -> {
            MicrosoftGraphPlannerPlan deserializedMicrosoftGraphPlannerPlan = new MicrosoftGraphPlannerPlan();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerPlan.withId(reader.getString());
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerPlan.createdBy = MicrosoftGraphIdentitySet.fromJson(reader);
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerPlan.createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("owner".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerPlan.owner = reader.getString();
                    continue;
                }
                if ("title".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerPlan.title = reader.getString();
                    continue;
                }
                if ("buckets".equals(fieldName)) {
                    List buckets;
                    deserializedMicrosoftGraphPlannerPlan.buckets = buckets = reader.readArray(reader1 -> MicrosoftGraphPlannerBucket.fromJson(reader1));
                    continue;
                }
                if ("details".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerPlan.details = MicrosoftGraphPlannerPlanDetails.fromJson(reader);
                    continue;
                }
                if ("tasks".equals(fieldName)) {
                    List tasks;
                    deserializedMicrosoftGraphPlannerPlan.tasks = tasks = reader.readArray(reader1 -> MicrosoftGraphPlannerTask.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphPlannerPlan.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphPlannerPlan;
        });
    }
}

