/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphScheduleEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphScheduleEntityTheme;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphShiftActivity;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MicrosoftGraphShiftItem
extends MicrosoftGraphScheduleEntity {
    private List<MicrosoftGraphShiftActivity> activities;
    private String displayName;
    private String notes;
    private Map<String, Object> additionalProperties;

    public List<MicrosoftGraphShiftActivity> activities() {
        return this.activities;
    }

    public MicrosoftGraphShiftItem withActivities(List<MicrosoftGraphShiftActivity> activities) {
        this.activities = activities;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public MicrosoftGraphShiftItem withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String notes() {
        return this.notes;
    }

    public MicrosoftGraphShiftItem withNotes(String notes) {
        this.notes = notes;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphShiftItem withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphShiftItem withEndDateTime(OffsetDateTime endDateTime) {
        super.withEndDateTime(endDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphShiftItem withStartDateTime(OffsetDateTime startDateTime) {
        super.withStartDateTime(startDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphShiftItem withTheme(MicrosoftGraphScheduleEntityTheme theme) {
        super.withTheme(theme);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.activities() != null) {
            this.activities().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endDateTime", this.endDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endDateTime()));
        jsonWriter.writeStringField("startDateTime", this.startDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startDateTime()));
        jsonWriter.writeStringField("theme", this.theme() == null ? null : this.theme().toString());
        jsonWriter.writeArrayField("activities", this.activities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("notes", this.notes);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphShiftItem fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphShiftItem)jsonReader.readObject(reader -> {
            MicrosoftGraphShiftItem deserializedMicrosoftGraphShiftItem = new MicrosoftGraphShiftItem();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphShiftItem.withEndDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("startDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphShiftItem.withStartDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("theme".equals(fieldName)) {
                    deserializedMicrosoftGraphShiftItem.withTheme(MicrosoftGraphScheduleEntityTheme.fromString(reader.getString()));
                    continue;
                }
                if ("activities".equals(fieldName)) {
                    List activities;
                    deserializedMicrosoftGraphShiftItem.activities = activities = reader.readArray(reader1 -> MicrosoftGraphShiftActivity.fromJson(reader1));
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphShiftItem.displayName = reader.getString();
                    continue;
                }
                if ("notes".equals(fieldName)) {
                    deserializedMicrosoftGraphShiftItem.notes = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphShiftItem.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphShiftItem;
        });
    }
}

