/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphComplianceState;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphConfigurationManagerClientEnabledFeatures;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDeviceActionResult;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDeviceCategory;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDeviceCompliancePolicyState;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDeviceConfigurationState;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDeviceEnrollmentType;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDeviceHealthAttestationState;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDeviceManagementExchangeAccessState;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDeviceManagementExchangeAccessStateReason;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDeviceRegistrationState;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphManagedDeviceOwnerType;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphManagedDevicePartnerReportedHealthState;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphManagementAgentType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphManagedDevice
extends MicrosoftGraphEntity {
    private String activationLockBypassCode;
    private String androidSecurityPatchLevel;
    private String azureADDeviceId;
    private Boolean azureADRegistered;
    private OffsetDateTime complianceGracePeriodExpirationDateTime;
    private MicrosoftGraphComplianceState complianceState;
    private MicrosoftGraphConfigurationManagerClientEnabledFeatures configurationManagerClientEnabledFeatures;
    private List<MicrosoftGraphDeviceActionResult> deviceActionResults;
    private String deviceCategoryDisplayName;
    private MicrosoftGraphDeviceEnrollmentType deviceEnrollmentType;
    private MicrosoftGraphDeviceHealthAttestationState deviceHealthAttestationState;
    private String deviceName;
    private MicrosoftGraphDeviceRegistrationState deviceRegistrationState;
    private Boolean easActivated;
    private OffsetDateTime easActivationDateTime;
    private String easDeviceId;
    private String emailAddress;
    private OffsetDateTime enrolledDateTime;
    private MicrosoftGraphDeviceManagementExchangeAccessState exchangeAccessState;
    private MicrosoftGraphDeviceManagementExchangeAccessStateReason exchangeAccessStateReason;
    private OffsetDateTime exchangeLastSuccessfulSyncDateTime;
    private Long freeStorageSpaceInBytes;
    private String imei;
    private Boolean isEncrypted;
    private Boolean isSupervised;
    private String jailBroken;
    private OffsetDateTime lastSyncDateTime;
    private String managedDeviceName;
    private MicrosoftGraphManagedDeviceOwnerType managedDeviceOwnerType;
    private MicrosoftGraphManagementAgentType managementAgent;
    private String manufacturer;
    private String meid;
    private String model;
    private String operatingSystem;
    private String osVersion;
    private MicrosoftGraphManagedDevicePartnerReportedHealthState partnerReportedThreatState;
    private String phoneNumber;
    private String remoteAssistanceSessionErrorDetails;
    private String remoteAssistanceSessionUrl;
    private String serialNumber;
    private String subscriberCarrier;
    private Long totalStorageSpaceInBytes;
    private String userDisplayName;
    private String userId;
    private String userPrincipalName;
    private String wiFiMacAddress;
    private List<MicrosoftGraphDeviceCompliancePolicyState> deviceCompliancePolicyStates;
    private List<MicrosoftGraphDeviceConfigurationState> deviceConfigurationStates;
    private MicrosoftGraphDeviceCategory deviceCategory;
    private Map<String, Object> additionalProperties;

    public String activationLockBypassCode() {
        return this.activationLockBypassCode;
    }

    public MicrosoftGraphManagedDevice withActivationLockBypassCode(String activationLockBypassCode) {
        this.activationLockBypassCode = activationLockBypassCode;
        return this;
    }

    public String androidSecurityPatchLevel() {
        return this.androidSecurityPatchLevel;
    }

    public MicrosoftGraphManagedDevice withAndroidSecurityPatchLevel(String androidSecurityPatchLevel) {
        this.androidSecurityPatchLevel = androidSecurityPatchLevel;
        return this;
    }

    public String azureADDeviceId() {
        return this.azureADDeviceId;
    }

    public MicrosoftGraphManagedDevice withAzureADDeviceId(String azureADDeviceId) {
        this.azureADDeviceId = azureADDeviceId;
        return this;
    }

    public Boolean azureADRegistered() {
        return this.azureADRegistered;
    }

    public MicrosoftGraphManagedDevice withAzureADRegistered(Boolean azureADRegistered) {
        this.azureADRegistered = azureADRegistered;
        return this;
    }

    public OffsetDateTime complianceGracePeriodExpirationDateTime() {
        return this.complianceGracePeriodExpirationDateTime;
    }

    public MicrosoftGraphManagedDevice withComplianceGracePeriodExpirationDateTime(OffsetDateTime complianceGracePeriodExpirationDateTime) {
        this.complianceGracePeriodExpirationDateTime = complianceGracePeriodExpirationDateTime;
        return this;
    }

    public MicrosoftGraphComplianceState complianceState() {
        return this.complianceState;
    }

    public MicrosoftGraphManagedDevice withComplianceState(MicrosoftGraphComplianceState complianceState) {
        this.complianceState = complianceState;
        return this;
    }

    public MicrosoftGraphConfigurationManagerClientEnabledFeatures configurationManagerClientEnabledFeatures() {
        return this.configurationManagerClientEnabledFeatures;
    }

    public MicrosoftGraphManagedDevice withConfigurationManagerClientEnabledFeatures(MicrosoftGraphConfigurationManagerClientEnabledFeatures configurationManagerClientEnabledFeatures) {
        this.configurationManagerClientEnabledFeatures = configurationManagerClientEnabledFeatures;
        return this;
    }

    public List<MicrosoftGraphDeviceActionResult> deviceActionResults() {
        return this.deviceActionResults;
    }

    public MicrosoftGraphManagedDevice withDeviceActionResults(List<MicrosoftGraphDeviceActionResult> deviceActionResults) {
        this.deviceActionResults = deviceActionResults;
        return this;
    }

    public String deviceCategoryDisplayName() {
        return this.deviceCategoryDisplayName;
    }

    public MicrosoftGraphManagedDevice withDeviceCategoryDisplayName(String deviceCategoryDisplayName) {
        this.deviceCategoryDisplayName = deviceCategoryDisplayName;
        return this;
    }

    public MicrosoftGraphDeviceEnrollmentType deviceEnrollmentType() {
        return this.deviceEnrollmentType;
    }

    public MicrosoftGraphManagedDevice withDeviceEnrollmentType(MicrosoftGraphDeviceEnrollmentType deviceEnrollmentType) {
        this.deviceEnrollmentType = deviceEnrollmentType;
        return this;
    }

    public MicrosoftGraphDeviceHealthAttestationState deviceHealthAttestationState() {
        return this.deviceHealthAttestationState;
    }

    public MicrosoftGraphManagedDevice withDeviceHealthAttestationState(MicrosoftGraphDeviceHealthAttestationState deviceHealthAttestationState) {
        this.deviceHealthAttestationState = deviceHealthAttestationState;
        return this;
    }

    public String deviceName() {
        return this.deviceName;
    }

    public MicrosoftGraphManagedDevice withDeviceName(String deviceName) {
        this.deviceName = deviceName;
        return this;
    }

    public MicrosoftGraphDeviceRegistrationState deviceRegistrationState() {
        return this.deviceRegistrationState;
    }

    public MicrosoftGraphManagedDevice withDeviceRegistrationState(MicrosoftGraphDeviceRegistrationState deviceRegistrationState) {
        this.deviceRegistrationState = deviceRegistrationState;
        return this;
    }

    public Boolean easActivated() {
        return this.easActivated;
    }

    public MicrosoftGraphManagedDevice withEasActivated(Boolean easActivated) {
        this.easActivated = easActivated;
        return this;
    }

    public OffsetDateTime easActivationDateTime() {
        return this.easActivationDateTime;
    }

    public MicrosoftGraphManagedDevice withEasActivationDateTime(OffsetDateTime easActivationDateTime) {
        this.easActivationDateTime = easActivationDateTime;
        return this;
    }

    public String easDeviceId() {
        return this.easDeviceId;
    }

    public MicrosoftGraphManagedDevice withEasDeviceId(String easDeviceId) {
        this.easDeviceId = easDeviceId;
        return this;
    }

    public String emailAddress() {
        return this.emailAddress;
    }

    public MicrosoftGraphManagedDevice withEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    public OffsetDateTime enrolledDateTime() {
        return this.enrolledDateTime;
    }

    public MicrosoftGraphManagedDevice withEnrolledDateTime(OffsetDateTime enrolledDateTime) {
        this.enrolledDateTime = enrolledDateTime;
        return this;
    }

    public MicrosoftGraphDeviceManagementExchangeAccessState exchangeAccessState() {
        return this.exchangeAccessState;
    }

    public MicrosoftGraphManagedDevice withExchangeAccessState(MicrosoftGraphDeviceManagementExchangeAccessState exchangeAccessState) {
        this.exchangeAccessState = exchangeAccessState;
        return this;
    }

    public MicrosoftGraphDeviceManagementExchangeAccessStateReason exchangeAccessStateReason() {
        return this.exchangeAccessStateReason;
    }

    public MicrosoftGraphManagedDevice withExchangeAccessStateReason(MicrosoftGraphDeviceManagementExchangeAccessStateReason exchangeAccessStateReason) {
        this.exchangeAccessStateReason = exchangeAccessStateReason;
        return this;
    }

    public OffsetDateTime exchangeLastSuccessfulSyncDateTime() {
        return this.exchangeLastSuccessfulSyncDateTime;
    }

    public MicrosoftGraphManagedDevice withExchangeLastSuccessfulSyncDateTime(OffsetDateTime exchangeLastSuccessfulSyncDateTime) {
        this.exchangeLastSuccessfulSyncDateTime = exchangeLastSuccessfulSyncDateTime;
        return this;
    }

    public Long freeStorageSpaceInBytes() {
        return this.freeStorageSpaceInBytes;
    }

    public MicrosoftGraphManagedDevice withFreeStorageSpaceInBytes(Long freeStorageSpaceInBytes) {
        this.freeStorageSpaceInBytes = freeStorageSpaceInBytes;
        return this;
    }

    public String imei() {
        return this.imei;
    }

    public MicrosoftGraphManagedDevice withImei(String imei) {
        this.imei = imei;
        return this;
    }

    public Boolean isEncrypted() {
        return this.isEncrypted;
    }

    public MicrosoftGraphManagedDevice withIsEncrypted(Boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
        return this;
    }

    public Boolean isSupervised() {
        return this.isSupervised;
    }

    public MicrosoftGraphManagedDevice withIsSupervised(Boolean isSupervised) {
        this.isSupervised = isSupervised;
        return this;
    }

    public String jailBroken() {
        return this.jailBroken;
    }

    public MicrosoftGraphManagedDevice withJailBroken(String jailBroken) {
        this.jailBroken = jailBroken;
        return this;
    }

    public OffsetDateTime lastSyncDateTime() {
        return this.lastSyncDateTime;
    }

    public MicrosoftGraphManagedDevice withLastSyncDateTime(OffsetDateTime lastSyncDateTime) {
        this.lastSyncDateTime = lastSyncDateTime;
        return this;
    }

    public String managedDeviceName() {
        return this.managedDeviceName;
    }

    public MicrosoftGraphManagedDevice withManagedDeviceName(String managedDeviceName) {
        this.managedDeviceName = managedDeviceName;
        return this;
    }

    public MicrosoftGraphManagedDeviceOwnerType managedDeviceOwnerType() {
        return this.managedDeviceOwnerType;
    }

    public MicrosoftGraphManagedDevice withManagedDeviceOwnerType(MicrosoftGraphManagedDeviceOwnerType managedDeviceOwnerType) {
        this.managedDeviceOwnerType = managedDeviceOwnerType;
        return this;
    }

    public MicrosoftGraphManagementAgentType managementAgent() {
        return this.managementAgent;
    }

    public MicrosoftGraphManagedDevice withManagementAgent(MicrosoftGraphManagementAgentType managementAgent) {
        this.managementAgent = managementAgent;
        return this;
    }

    public String manufacturer() {
        return this.manufacturer;
    }

    public MicrosoftGraphManagedDevice withManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
        return this;
    }

    public String meid() {
        return this.meid;
    }

    public MicrosoftGraphManagedDevice withMeid(String meid) {
        this.meid = meid;
        return this;
    }

    public String model() {
        return this.model;
    }

    public MicrosoftGraphManagedDevice withModel(String model) {
        this.model = model;
        return this;
    }

    public String operatingSystem() {
        return this.operatingSystem;
    }

    public MicrosoftGraphManagedDevice withOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
        return this;
    }

    public String osVersion() {
        return this.osVersion;
    }

    public MicrosoftGraphManagedDevice withOsVersion(String osVersion) {
        this.osVersion = osVersion;
        return this;
    }

    public MicrosoftGraphManagedDevicePartnerReportedHealthState partnerReportedThreatState() {
        return this.partnerReportedThreatState;
    }

    public MicrosoftGraphManagedDevice withPartnerReportedThreatState(MicrosoftGraphManagedDevicePartnerReportedHealthState partnerReportedThreatState) {
        this.partnerReportedThreatState = partnerReportedThreatState;
        return this;
    }

    public String phoneNumber() {
        return this.phoneNumber;
    }

    public MicrosoftGraphManagedDevice withPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    public String remoteAssistanceSessionErrorDetails() {
        return this.remoteAssistanceSessionErrorDetails;
    }

    public MicrosoftGraphManagedDevice withRemoteAssistanceSessionErrorDetails(String remoteAssistanceSessionErrorDetails) {
        this.remoteAssistanceSessionErrorDetails = remoteAssistanceSessionErrorDetails;
        return this;
    }

    public String remoteAssistanceSessionUrl() {
        return this.remoteAssistanceSessionUrl;
    }

    public MicrosoftGraphManagedDevice withRemoteAssistanceSessionUrl(String remoteAssistanceSessionUrl) {
        this.remoteAssistanceSessionUrl = remoteAssistanceSessionUrl;
        return this;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public MicrosoftGraphManagedDevice withSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    public String subscriberCarrier() {
        return this.subscriberCarrier;
    }

    public MicrosoftGraphManagedDevice withSubscriberCarrier(String subscriberCarrier) {
        this.subscriberCarrier = subscriberCarrier;
        return this;
    }

    public Long totalStorageSpaceInBytes() {
        return this.totalStorageSpaceInBytes;
    }

    public MicrosoftGraphManagedDevice withTotalStorageSpaceInBytes(Long totalStorageSpaceInBytes) {
        this.totalStorageSpaceInBytes = totalStorageSpaceInBytes;
        return this;
    }

    public String userDisplayName() {
        return this.userDisplayName;
    }

    public MicrosoftGraphManagedDevice withUserDisplayName(String userDisplayName) {
        this.userDisplayName = userDisplayName;
        return this;
    }

    public String userId() {
        return this.userId;
    }

    public MicrosoftGraphManagedDevice withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String userPrincipalName() {
        return this.userPrincipalName;
    }

    public MicrosoftGraphManagedDevice withUserPrincipalName(String userPrincipalName) {
        this.userPrincipalName = userPrincipalName;
        return this;
    }

    public String wiFiMacAddress() {
        return this.wiFiMacAddress;
    }

    public MicrosoftGraphManagedDevice withWiFiMacAddress(String wiFiMacAddress) {
        this.wiFiMacAddress = wiFiMacAddress;
        return this;
    }

    public List<MicrosoftGraphDeviceCompliancePolicyState> deviceCompliancePolicyStates() {
        return this.deviceCompliancePolicyStates;
    }

    public MicrosoftGraphManagedDevice withDeviceCompliancePolicyStates(List<MicrosoftGraphDeviceCompliancePolicyState> deviceCompliancePolicyStates) {
        this.deviceCompliancePolicyStates = deviceCompliancePolicyStates;
        return this;
    }

    public List<MicrosoftGraphDeviceConfigurationState> deviceConfigurationStates() {
        return this.deviceConfigurationStates;
    }

    public MicrosoftGraphManagedDevice withDeviceConfigurationStates(List<MicrosoftGraphDeviceConfigurationState> deviceConfigurationStates) {
        this.deviceConfigurationStates = deviceConfigurationStates;
        return this;
    }

    public MicrosoftGraphDeviceCategory deviceCategory() {
        return this.deviceCategory;
    }

    public MicrosoftGraphManagedDevice withDeviceCategory(MicrosoftGraphDeviceCategory deviceCategory) {
        this.deviceCategory = deviceCategory;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphManagedDevice withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphManagedDevice withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.configurationManagerClientEnabledFeatures() != null) {
            this.configurationManagerClientEnabledFeatures().validate();
        }
        if (this.deviceActionResults() != null) {
            this.deviceActionResults().forEach(e -> e.validate());
        }
        if (this.deviceHealthAttestationState() != null) {
            this.deviceHealthAttestationState().validate();
        }
        if (this.deviceCompliancePolicyStates() != null) {
            this.deviceCompliancePolicyStates().forEach(e -> e.validate());
        }
        if (this.deviceConfigurationStates() != null) {
            this.deviceConfigurationStates().forEach(e -> e.validate());
        }
        if (this.deviceCategory() != null) {
            this.deviceCategory().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("activationLockBypassCode", this.activationLockBypassCode);
        jsonWriter.writeStringField("androidSecurityPatchLevel", this.androidSecurityPatchLevel);
        jsonWriter.writeStringField("azureADDeviceId", this.azureADDeviceId);
        jsonWriter.writeBooleanField("azureADRegistered", this.azureADRegistered);
        jsonWriter.writeStringField("complianceGracePeriodExpirationDateTime", this.complianceGracePeriodExpirationDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.complianceGracePeriodExpirationDateTime));
        jsonWriter.writeStringField("complianceState", this.complianceState == null ? null : this.complianceState.toString());
        jsonWriter.writeJsonField("configurationManagerClientEnabledFeatures", (JsonSerializable)this.configurationManagerClientEnabledFeatures);
        jsonWriter.writeArrayField("deviceActionResults", this.deviceActionResults, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("deviceCategoryDisplayName", this.deviceCategoryDisplayName);
        jsonWriter.writeStringField("deviceEnrollmentType", this.deviceEnrollmentType == null ? null : this.deviceEnrollmentType.toString());
        jsonWriter.writeJsonField("deviceHealthAttestationState", (JsonSerializable)this.deviceHealthAttestationState);
        jsonWriter.writeStringField("deviceName", this.deviceName);
        jsonWriter.writeStringField("deviceRegistrationState", this.deviceRegistrationState == null ? null : this.deviceRegistrationState.toString());
        jsonWriter.writeBooleanField("easActivated", this.easActivated);
        jsonWriter.writeStringField("easActivationDateTime", this.easActivationDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.easActivationDateTime));
        jsonWriter.writeStringField("easDeviceId", this.easDeviceId);
        jsonWriter.writeStringField("emailAddress", this.emailAddress);
        jsonWriter.writeStringField("enrolledDateTime", this.enrolledDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.enrolledDateTime));
        jsonWriter.writeStringField("exchangeAccessState", this.exchangeAccessState == null ? null : this.exchangeAccessState.toString());
        jsonWriter.writeStringField("exchangeAccessStateReason", this.exchangeAccessStateReason == null ? null : this.exchangeAccessStateReason.toString());
        jsonWriter.writeStringField("exchangeLastSuccessfulSyncDateTime", this.exchangeLastSuccessfulSyncDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.exchangeLastSuccessfulSyncDateTime));
        jsonWriter.writeNumberField("freeStorageSpaceInBytes", (Number)this.freeStorageSpaceInBytes);
        jsonWriter.writeStringField("imei", this.imei);
        jsonWriter.writeBooleanField("isEncrypted", this.isEncrypted);
        jsonWriter.writeBooleanField("isSupervised", this.isSupervised);
        jsonWriter.writeStringField("jailBroken", this.jailBroken);
        jsonWriter.writeStringField("lastSyncDateTime", this.lastSyncDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastSyncDateTime));
        jsonWriter.writeStringField("managedDeviceName", this.managedDeviceName);
        jsonWriter.writeStringField("managedDeviceOwnerType", this.managedDeviceOwnerType == null ? null : this.managedDeviceOwnerType.toString());
        jsonWriter.writeStringField("managementAgent", this.managementAgent == null ? null : this.managementAgent.toString());
        jsonWriter.writeStringField("manufacturer", this.manufacturer);
        jsonWriter.writeStringField("meid", this.meid);
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeStringField("operatingSystem", this.operatingSystem);
        jsonWriter.writeStringField("osVersion", this.osVersion);
        jsonWriter.writeStringField("partnerReportedThreatState", this.partnerReportedThreatState == null ? null : this.partnerReportedThreatState.toString());
        jsonWriter.writeStringField("phoneNumber", this.phoneNumber);
        jsonWriter.writeStringField("remoteAssistanceSessionErrorDetails", this.remoteAssistanceSessionErrorDetails);
        jsonWriter.writeStringField("remoteAssistanceSessionUrl", this.remoteAssistanceSessionUrl);
        jsonWriter.writeStringField("serialNumber", this.serialNumber);
        jsonWriter.writeStringField("subscriberCarrier", this.subscriberCarrier);
        jsonWriter.writeNumberField("totalStorageSpaceInBytes", (Number)this.totalStorageSpaceInBytes);
        jsonWriter.writeStringField("userDisplayName", this.userDisplayName);
        jsonWriter.writeStringField("userId", this.userId);
        jsonWriter.writeStringField("userPrincipalName", this.userPrincipalName);
        jsonWriter.writeStringField("wiFiMacAddress", this.wiFiMacAddress);
        jsonWriter.writeArrayField("deviceCompliancePolicyStates", this.deviceCompliancePolicyStates, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("deviceConfigurationStates", this.deviceConfigurationStates, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("deviceCategory", (JsonSerializable)this.deviceCategory);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphManagedDevice fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphManagedDevice)jsonReader.readObject(reader -> {
            MicrosoftGraphManagedDevice deserializedMicrosoftGraphManagedDevice = new MicrosoftGraphManagedDevice();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.withId(reader.getString());
                    continue;
                }
                if ("activationLockBypassCode".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.activationLockBypassCode = reader.getString();
                    continue;
                }
                if ("androidSecurityPatchLevel".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.androidSecurityPatchLevel = reader.getString();
                    continue;
                }
                if ("azureADDeviceId".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.azureADDeviceId = reader.getString();
                    continue;
                }
                if ("azureADRegistered".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.azureADRegistered = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("complianceGracePeriodExpirationDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.complianceGracePeriodExpirationDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("complianceState".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.complianceState = MicrosoftGraphComplianceState.fromString(reader.getString());
                    continue;
                }
                if ("configurationManagerClientEnabledFeatures".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.configurationManagerClientEnabledFeatures = MicrosoftGraphConfigurationManagerClientEnabledFeatures.fromJson(reader);
                    continue;
                }
                if ("deviceActionResults".equals(fieldName)) {
                    List deviceActionResults;
                    deserializedMicrosoftGraphManagedDevice.deviceActionResults = deviceActionResults = reader.readArray(reader1 -> MicrosoftGraphDeviceActionResult.fromJson(reader1));
                    continue;
                }
                if ("deviceCategoryDisplayName".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.deviceCategoryDisplayName = reader.getString();
                    continue;
                }
                if ("deviceEnrollmentType".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.deviceEnrollmentType = MicrosoftGraphDeviceEnrollmentType.fromString(reader.getString());
                    continue;
                }
                if ("deviceHealthAttestationState".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.deviceHealthAttestationState = MicrosoftGraphDeviceHealthAttestationState.fromJson(reader);
                    continue;
                }
                if ("deviceName".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.deviceName = reader.getString();
                    continue;
                }
                if ("deviceRegistrationState".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.deviceRegistrationState = MicrosoftGraphDeviceRegistrationState.fromString(reader.getString());
                    continue;
                }
                if ("easActivated".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.easActivated = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("easActivationDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.easActivationDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("easDeviceId".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.easDeviceId = reader.getString();
                    continue;
                }
                if ("emailAddress".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.emailAddress = reader.getString();
                    continue;
                }
                if ("enrolledDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.enrolledDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("exchangeAccessState".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.exchangeAccessState = MicrosoftGraphDeviceManagementExchangeAccessState.fromString(reader.getString());
                    continue;
                }
                if ("exchangeAccessStateReason".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.exchangeAccessStateReason = MicrosoftGraphDeviceManagementExchangeAccessStateReason.fromString(reader.getString());
                    continue;
                }
                if ("exchangeLastSuccessfulSyncDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.exchangeLastSuccessfulSyncDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("freeStorageSpaceInBytes".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.freeStorageSpaceInBytes = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("imei".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.imei = reader.getString();
                    continue;
                }
                if ("isEncrypted".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.isEncrypted = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isSupervised".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.isSupervised = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("jailBroken".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.jailBroken = reader.getString();
                    continue;
                }
                if ("lastSyncDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.lastSyncDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("managedDeviceName".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.managedDeviceName = reader.getString();
                    continue;
                }
                if ("managedDeviceOwnerType".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.managedDeviceOwnerType = MicrosoftGraphManagedDeviceOwnerType.fromString(reader.getString());
                    continue;
                }
                if ("managementAgent".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.managementAgent = MicrosoftGraphManagementAgentType.fromString(reader.getString());
                    continue;
                }
                if ("manufacturer".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.manufacturer = reader.getString();
                    continue;
                }
                if ("meid".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.meid = reader.getString();
                    continue;
                }
                if ("model".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.model = reader.getString();
                    continue;
                }
                if ("operatingSystem".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.operatingSystem = reader.getString();
                    continue;
                }
                if ("osVersion".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.osVersion = reader.getString();
                    continue;
                }
                if ("partnerReportedThreatState".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.partnerReportedThreatState = MicrosoftGraphManagedDevicePartnerReportedHealthState.fromString(reader.getString());
                    continue;
                }
                if ("phoneNumber".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.phoneNumber = reader.getString();
                    continue;
                }
                if ("remoteAssistanceSessionErrorDetails".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.remoteAssistanceSessionErrorDetails = reader.getString();
                    continue;
                }
                if ("remoteAssistanceSessionUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.remoteAssistanceSessionUrl = reader.getString();
                    continue;
                }
                if ("serialNumber".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.serialNumber = reader.getString();
                    continue;
                }
                if ("subscriberCarrier".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.subscriberCarrier = reader.getString();
                    continue;
                }
                if ("totalStorageSpaceInBytes".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.totalStorageSpaceInBytes = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("userDisplayName".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.userDisplayName = reader.getString();
                    continue;
                }
                if ("userId".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.userId = reader.getString();
                    continue;
                }
                if ("userPrincipalName".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.userPrincipalName = reader.getString();
                    continue;
                }
                if ("wiFiMacAddress".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.wiFiMacAddress = reader.getString();
                    continue;
                }
                if ("deviceCompliancePolicyStates".equals(fieldName)) {
                    List deviceCompliancePolicyStates;
                    deserializedMicrosoftGraphManagedDevice.deviceCompliancePolicyStates = deviceCompliancePolicyStates = reader.readArray(reader1 -> MicrosoftGraphDeviceCompliancePolicyState.fromJson(reader1));
                    continue;
                }
                if ("deviceConfigurationStates".equals(fieldName)) {
                    List deviceConfigurationStates;
                    deserializedMicrosoftGraphManagedDevice.deviceConfigurationStates = deviceConfigurationStates = reader.readArray(reader1 -> MicrosoftGraphDeviceConfigurationState.fromJson(reader1));
                    continue;
                }
                if ("deviceCategory".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedDevice.deviceCategory = MicrosoftGraphDeviceCategory.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphManagedDevice.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphManagedDevice;
        });
    }
}

