/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.arizeaiobservabilityeval.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.arizeaiobservabilityeval.models.SingleSignOnStates;
import com.azure.resourcemanager.arizeaiobservabilityeval.models.SingleSignOnType;
import java.io.IOException;
import java.util.List;

public final class SingleSignOnPropertiesV2
implements JsonSerializable<SingleSignOnPropertiesV2> {
    private SingleSignOnType type;
    private SingleSignOnStates state;
    private String enterpriseAppId;
    private String url;
    private List<String> aadDomains;
    private static final ClientLogger LOGGER = new ClientLogger(SingleSignOnPropertiesV2.class);

    public SingleSignOnType type() {
        return this.type;
    }

    public SingleSignOnPropertiesV2 withType(SingleSignOnType type) {
        this.type = type;
        return this;
    }

    public SingleSignOnStates state() {
        return this.state;
    }

    public SingleSignOnPropertiesV2 withState(SingleSignOnStates state) {
        this.state = state;
        return this;
    }

    public String enterpriseAppId() {
        return this.enterpriseAppId;
    }

    public SingleSignOnPropertiesV2 withEnterpriseAppId(String enterpriseAppId) {
        this.enterpriseAppId = enterpriseAppId;
        return this;
    }

    public String url() {
        return this.url;
    }

    public SingleSignOnPropertiesV2 withUrl(String url) {
        this.url = url;
        return this;
    }

    public List<String> aadDomains() {
        return this.aadDomains;
    }

    public SingleSignOnPropertiesV2 withAadDomains(List<String> aadDomains) {
        this.aadDomains = aadDomains;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model SingleSignOnPropertiesV2"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("enterpriseAppId", this.enterpriseAppId);
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeArrayField("aadDomains", this.aadDomains, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static SingleSignOnPropertiesV2 fromJson(JsonReader jsonReader) throws IOException {
        return (SingleSignOnPropertiesV2)jsonReader.readObject(reader -> {
            SingleSignOnPropertiesV2 deserializedSingleSignOnPropertiesV2 = new SingleSignOnPropertiesV2();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedSingleSignOnPropertiesV2.type = SingleSignOnType.fromString(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedSingleSignOnPropertiesV2.state = SingleSignOnStates.fromString(reader.getString());
                    continue;
                }
                if ("enterpriseAppId".equals(fieldName)) {
                    deserializedSingleSignOnPropertiesV2.enterpriseAppId = reader.getString();
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedSingleSignOnPropertiesV2.url = reader.getString();
                    continue;
                }
                if ("aadDomains".equals(fieldName)) {
                    List aadDomains;
                    deserializedSingleSignOnPropertiesV2.aadDomains = aadDomains = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSingleSignOnPropertiesV2;
        });
    }
}

