/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.TrafficDirection;
import java.io.IOException;
import java.util.List;

public final class RequiredTraffic
implements JsonSerializable<RequiredTraffic> {
    private String protocol;
    private Integer port;
    private List<String> ips;
    private List<String> fqdns;
    private TrafficDirection direction;

    public String protocol() {
        return this.protocol;
    }

    public Integer port() {
        return this.port;
    }

    public List<String> ips() {
        return this.ips;
    }

    public List<String> fqdns() {
        return this.fqdns;
    }

    public TrafficDirection direction() {
        return this.direction;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static RequiredTraffic fromJson(JsonReader jsonReader) throws IOException {
        return (RequiredTraffic)jsonReader.readObject(reader -> {
            RequiredTraffic deserializedRequiredTraffic = new RequiredTraffic();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("protocol".equals(fieldName)) {
                    deserializedRequiredTraffic.protocol = reader.getString();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedRequiredTraffic.port = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("ips".equals(fieldName)) {
                    List ips;
                    deserializedRequiredTraffic.ips = ips = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("fqdns".equals(fieldName)) {
                    List fqdns;
                    deserializedRequiredTraffic.fqdns = fqdns = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("direction".equals(fieldName)) {
                    deserializedRequiredTraffic.direction = TrafficDirection.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRequiredTraffic;
        });
    }
}

