/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.BackendProtocol;
import com.azure.resourcemanager.appplatform.models.IngressSettingsClientAuth;
import com.azure.resourcemanager.appplatform.models.SessionAffinity;
import java.io.IOException;

public final class IngressSettings
implements JsonSerializable<IngressSettings> {
    private Integer readTimeoutInSeconds;
    private Integer sendTimeoutInSeconds;
    private SessionAffinity sessionAffinity;
    private Integer sessionCookieMaxAge;
    private BackendProtocol backendProtocol;
    private IngressSettingsClientAuth clientAuth;

    public Integer readTimeoutInSeconds() {
        return this.readTimeoutInSeconds;
    }

    public IngressSettings withReadTimeoutInSeconds(Integer readTimeoutInSeconds) {
        this.readTimeoutInSeconds = readTimeoutInSeconds;
        return this;
    }

    public Integer sendTimeoutInSeconds() {
        return this.sendTimeoutInSeconds;
    }

    public IngressSettings withSendTimeoutInSeconds(Integer sendTimeoutInSeconds) {
        this.sendTimeoutInSeconds = sendTimeoutInSeconds;
        return this;
    }

    public SessionAffinity sessionAffinity() {
        return this.sessionAffinity;
    }

    public IngressSettings withSessionAffinity(SessionAffinity sessionAffinity) {
        this.sessionAffinity = sessionAffinity;
        return this;
    }

    public Integer sessionCookieMaxAge() {
        return this.sessionCookieMaxAge;
    }

    public IngressSettings withSessionCookieMaxAge(Integer sessionCookieMaxAge) {
        this.sessionCookieMaxAge = sessionCookieMaxAge;
        return this;
    }

    public BackendProtocol backendProtocol() {
        return this.backendProtocol;
    }

    public IngressSettings withBackendProtocol(BackendProtocol backendProtocol) {
        this.backendProtocol = backendProtocol;
        return this;
    }

    public IngressSettingsClientAuth clientAuth() {
        return this.clientAuth;
    }

    public IngressSettings withClientAuth(IngressSettingsClientAuth clientAuth) {
        this.clientAuth = clientAuth;
        return this;
    }

    public void validate() {
        if (this.clientAuth() != null) {
            this.clientAuth().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("readTimeoutInSeconds", (Number)this.readTimeoutInSeconds);
        jsonWriter.writeNumberField("sendTimeoutInSeconds", (Number)this.sendTimeoutInSeconds);
        jsonWriter.writeStringField("sessionAffinity", this.sessionAffinity == null ? null : this.sessionAffinity.toString());
        jsonWriter.writeNumberField("sessionCookieMaxAge", (Number)this.sessionCookieMaxAge);
        jsonWriter.writeStringField("backendProtocol", this.backendProtocol == null ? null : this.backendProtocol.toString());
        jsonWriter.writeJsonField("clientAuth", (JsonSerializable)this.clientAuth);
        return jsonWriter.writeEndObject();
    }

    public static IngressSettings fromJson(JsonReader jsonReader) throws IOException {
        return (IngressSettings)jsonReader.readObject(reader -> {
            IngressSettings deserializedIngressSettings = new IngressSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("readTimeoutInSeconds".equals(fieldName)) {
                    deserializedIngressSettings.readTimeoutInSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("sendTimeoutInSeconds".equals(fieldName)) {
                    deserializedIngressSettings.sendTimeoutInSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("sessionAffinity".equals(fieldName)) {
                    deserializedIngressSettings.sessionAffinity = SessionAffinity.fromString(reader.getString());
                    continue;
                }
                if ("sessionCookieMaxAge".equals(fieldName)) {
                    deserializedIngressSettings.sessionCookieMaxAge = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("backendProtocol".equals(fieldName)) {
                    deserializedIngressSettings.backendProtocol = BackendProtocol.fromString(reader.getString());
                    continue;
                }
                if ("clientAuth".equals(fieldName)) {
                    deserializedIngressSettings.clientAuth = IngressSettingsClientAuth.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIngressSettings;
        });
    }
}

