/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.ConfigurationServiceGeneration;
import com.azure.resourcemanager.appplatform.models.ConfigurationServiceInstance;
import com.azure.resourcemanager.appplatform.models.ConfigurationServiceProvisioningState;
import com.azure.resourcemanager.appplatform.models.ConfigurationServiceResourceRequests;
import com.azure.resourcemanager.appplatform.models.ConfigurationServiceSettings;
import java.io.IOException;
import java.util.List;

public final class ConfigurationServiceProperties
implements JsonSerializable<ConfigurationServiceProperties> {
    private ConfigurationServiceProvisioningState provisioningState;
    private ConfigurationServiceGeneration generation;
    private ConfigurationServiceResourceRequests resourceRequests;
    private List<ConfigurationServiceInstance> instances;
    private ConfigurationServiceSettings settings;

    public ConfigurationServiceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ConfigurationServiceGeneration generation() {
        return this.generation;
    }

    public ConfigurationServiceProperties withGeneration(ConfigurationServiceGeneration generation) {
        this.generation = generation;
        return this;
    }

    public ConfigurationServiceResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    public List<ConfigurationServiceInstance> instances() {
        return this.instances;
    }

    public ConfigurationServiceSettings settings() {
        return this.settings;
    }

    public ConfigurationServiceProperties withSettings(ConfigurationServiceSettings settings) {
        this.settings = settings;
        return this;
    }

    public void validate() {
        if (this.resourceRequests() != null) {
            this.resourceRequests().validate();
        }
        if (this.instances() != null) {
            this.instances().forEach(e -> e.validate());
        }
        if (this.settings() != null) {
            this.settings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("generation", this.generation == null ? null : this.generation.toString());
        jsonWriter.writeJsonField("settings", (JsonSerializable)this.settings);
        return jsonWriter.writeEndObject();
    }

    public static ConfigurationServiceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ConfigurationServiceProperties)jsonReader.readObject(reader -> {
            ConfigurationServiceProperties deserializedConfigurationServiceProperties = new ConfigurationServiceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedConfigurationServiceProperties.provisioningState = ConfigurationServiceProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("generation".equals(fieldName)) {
                    deserializedConfigurationServiceProperties.generation = ConfigurationServiceGeneration.fromString(reader.getString());
                    continue;
                }
                if ("resourceRequests".equals(fieldName)) {
                    deserializedConfigurationServiceProperties.resourceRequests = ConfigurationServiceResourceRequests.fromJson(reader);
                    continue;
                }
                if ("instances".equals(fieldName)) {
                    List instances;
                    deserializedConfigurationServiceProperties.instances = instances = reader.readArray(reader1 -> ConfigurationServiceInstance.fromJson(reader1));
                    continue;
                }
                if ("settings".equals(fieldName)) {
                    deserializedConfigurationServiceProperties.settings = ConfigurationServiceSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConfigurationServiceProperties;
        });
    }
}

