/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.BuildServicePropertiesResourceRequests;
import com.azure.resourcemanager.appplatform.models.BuildServiceProvisioningState;
import java.io.IOException;

public final class BuildServiceProperties
implements JsonSerializable<BuildServiceProperties> {
    private String containerRegistry;
    private String kPackVersion;
    private BuildServiceProvisioningState provisioningState;
    private BuildServicePropertiesResourceRequests resourceRequests;

    public String containerRegistry() {
        return this.containerRegistry;
    }

    public BuildServiceProperties withContainerRegistry(String containerRegistry) {
        this.containerRegistry = containerRegistry;
        return this;
    }

    public String kPackVersion() {
        return this.kPackVersion;
    }

    public BuildServiceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public BuildServicePropertiesResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    public BuildServiceProperties withResourceRequests(BuildServicePropertiesResourceRequests resourceRequests) {
        this.resourceRequests = resourceRequests;
        return this;
    }

    public void validate() {
        if (this.resourceRequests() != null) {
            this.resourceRequests().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("containerRegistry", this.containerRegistry);
        jsonWriter.writeJsonField("resourceRequests", (JsonSerializable)this.resourceRequests);
        return jsonWriter.writeEndObject();
    }

    public static BuildServiceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BuildServiceProperties)jsonReader.readObject(reader -> {
            BuildServiceProperties deserializedBuildServiceProperties = new BuildServiceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("containerRegistry".equals(fieldName)) {
                    deserializedBuildServiceProperties.containerRegistry = reader.getString();
                    continue;
                }
                if ("kPackVersion".equals(fieldName)) {
                    deserializedBuildServiceProperties.kPackVersion = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedBuildServiceProperties.provisioningState = BuildServiceProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("resourceRequests".equals(fieldName)) {
                    deserializedBuildServiceProperties.resourceRequests = BuildServicePropertiesResourceRequests.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBuildServiceProperties;
        });
    }
}

