/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.CustomPersistentDiskProperties;
import com.azure.resourcemanager.appplatform.models.Type;
import java.io.IOException;
import java.util.List;

public final class AzureFileVolume
extends CustomPersistentDiskProperties {
    private Type type = Type.AZURE_FILE_VOLUME;
    private String shareName;

    @Override
    public Type type() {
        return this.type;
    }

    public String shareName() {
        return this.shareName;
    }

    public AzureFileVolume withShareName(String shareName) {
        this.shareName = shareName;
        return this;
    }

    @Override
    public AzureFileVolume withMountPath(String mountPath) {
        super.withMountPath(mountPath);
        return this;
    }

    @Override
    public AzureFileVolume withReadOnly(Boolean readOnly) {
        super.withReadOnly(readOnly);
        return this;
    }

    @Override
    public AzureFileVolume withEnableSubPath(Boolean enableSubPath) {
        super.withEnableSubPath(enableSubPath);
        return this;
    }

    @Override
    public AzureFileVolume withMountOptions(List<String> mountOptions) {
        super.withMountOptions(mountOptions);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mountPath", this.mountPath());
        jsonWriter.writeBooleanField("readOnly", this.readOnly());
        jsonWriter.writeBooleanField("enableSubPath", this.enableSubPath());
        jsonWriter.writeArrayField("mountOptions", this.mountOptions(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("shareName", this.shareName);
        return jsonWriter.writeEndObject();
    }

    public static AzureFileVolume fromJson(JsonReader jsonReader) throws IOException {
        return (AzureFileVolume)jsonReader.readObject(reader -> {
            AzureFileVolume deserializedAzureFileVolume = new AzureFileVolume();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("mountPath".equals(fieldName)) {
                    deserializedAzureFileVolume.withMountPath(reader.getString());
                    continue;
                }
                if ("readOnly".equals(fieldName)) {
                    deserializedAzureFileVolume.withReadOnly((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("enableSubPath".equals(fieldName)) {
                    deserializedAzureFileVolume.withEnableSubPath((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("mountOptions".equals(fieldName)) {
                    List mountOptions = reader.readArray(reader1 -> reader1.getString());
                    deserializedAzureFileVolume.withMountOptions(mountOptions);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureFileVolume.type = Type.fromString(reader.getString());
                    continue;
                }
                if ("shareName".equals(fieldName)) {
                    deserializedAzureFileVolume.shareName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureFileVolume;
        });
    }
}

