/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.ManagedIdentityType;
import com.azure.resourcemanager.appplatform.models.UserAssignedManagedIdentity;
import java.io.IOException;
import java.util.Map;

public final class ManagedIdentityProperties
implements JsonSerializable<ManagedIdentityProperties> {
    private ManagedIdentityType type;
    private String principalId;
    private String tenantId;
    private Map<String, UserAssignedManagedIdentity> userAssignedIdentities;

    public ManagedIdentityType type() {
        return this.type;
    }

    public ManagedIdentityProperties withType(ManagedIdentityType type) {
        this.type = type;
        return this;
    }

    public String principalId() {
        return this.principalId;
    }

    public ManagedIdentityProperties withPrincipalId(String principalId) {
        this.principalId = principalId;
        return this;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public ManagedIdentityProperties withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public Map<String, UserAssignedManagedIdentity> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public ManagedIdentityProperties withUserAssignedIdentities(Map<String, UserAssignedManagedIdentity> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public void validate() {
        if (this.userAssignedIdentities() != null) {
            this.userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("principalId", this.principalId);
        jsonWriter.writeStringField("tenantId", this.tenantId);
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ManagedIdentityProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedIdentityProperties)jsonReader.readObject(reader -> {
            ManagedIdentityProperties deserializedManagedIdentityProperties = new ManagedIdentityProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedManagedIdentityProperties.type = ManagedIdentityType.fromString(reader.getString());
                    continue;
                }
                if ("principalId".equals(fieldName)) {
                    deserializedManagedIdentityProperties.principalId = reader.getString();
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedManagedIdentityProperties.tenantId = reader.getString();
                    continue;
                }
                if ("userAssignedIdentities".equals(fieldName)) {
                    Map userAssignedIdentities;
                    deserializedManagedIdentityProperties.userAssignedIdentities = userAssignedIdentities = reader.readMap(reader1 -> UserAssignedManagedIdentity.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedIdentityProperties;
        });
    }
}

