/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.GitPatternRepository;
import java.io.IOException;
import java.util.List;

public final class ConfigServerGitProperty
implements JsonSerializable<ConfigServerGitProperty> {
    private List<GitPatternRepository> repositories;
    private String uri;
    private String label;
    private List<String> searchPaths;
    private String username;
    private String password;
    private String hostKey;
    private String hostKeyAlgorithm;
    private String privateKey;
    private Boolean strictHostKeyChecking;
    private static final ClientLogger LOGGER = new ClientLogger(ConfigServerGitProperty.class);

    public List<GitPatternRepository> repositories() {
        return this.repositories;
    }

    public ConfigServerGitProperty withRepositories(List<GitPatternRepository> repositories) {
        this.repositories = repositories;
        return this;
    }

    public String uri() {
        return this.uri;
    }

    public ConfigServerGitProperty withUri(String uri) {
        this.uri = uri;
        return this;
    }

    public String label() {
        return this.label;
    }

    public ConfigServerGitProperty withLabel(String label) {
        this.label = label;
        return this;
    }

    public List<String> searchPaths() {
        return this.searchPaths;
    }

    public ConfigServerGitProperty withSearchPaths(List<String> searchPaths) {
        this.searchPaths = searchPaths;
        return this;
    }

    public String username() {
        return this.username;
    }

    public ConfigServerGitProperty withUsername(String username) {
        this.username = username;
        return this;
    }

    public String password() {
        return this.password;
    }

    public ConfigServerGitProperty withPassword(String password) {
        this.password = password;
        return this;
    }

    public String hostKey() {
        return this.hostKey;
    }

    public ConfigServerGitProperty withHostKey(String hostKey) {
        this.hostKey = hostKey;
        return this;
    }

    public String hostKeyAlgorithm() {
        return this.hostKeyAlgorithm;
    }

    public ConfigServerGitProperty withHostKeyAlgorithm(String hostKeyAlgorithm) {
        this.hostKeyAlgorithm = hostKeyAlgorithm;
        return this;
    }

    public String privateKey() {
        return this.privateKey;
    }

    public ConfigServerGitProperty withPrivateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public Boolean strictHostKeyChecking() {
        return this.strictHostKeyChecking;
    }

    public ConfigServerGitProperty withStrictHostKeyChecking(Boolean strictHostKeyChecking) {
        this.strictHostKeyChecking = strictHostKeyChecking;
        return this;
    }

    public void validate() {
        if (this.repositories() != null) {
            this.repositories().forEach(e -> e.validate());
        }
        if (this.uri() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property uri in model ConfigServerGitProperty"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("uri", this.uri);
        jsonWriter.writeArrayField("repositories", this.repositories, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("label", this.label);
        jsonWriter.writeArrayField("searchPaths", this.searchPaths, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("username", this.username);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("hostKey", this.hostKey);
        jsonWriter.writeStringField("hostKeyAlgorithm", this.hostKeyAlgorithm);
        jsonWriter.writeStringField("privateKey", this.privateKey);
        jsonWriter.writeBooleanField("strictHostKeyChecking", this.strictHostKeyChecking);
        return jsonWriter.writeEndObject();
    }

    public static ConfigServerGitProperty fromJson(JsonReader jsonReader) throws IOException {
        return (ConfigServerGitProperty)jsonReader.readObject(reader -> {
            ConfigServerGitProperty deserializedConfigServerGitProperty = new ConfigServerGitProperty();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("uri".equals(fieldName)) {
                    deserializedConfigServerGitProperty.uri = reader.getString();
                    continue;
                }
                if ("repositories".equals(fieldName)) {
                    List repositories;
                    deserializedConfigServerGitProperty.repositories = repositories = reader.readArray(reader1 -> GitPatternRepository.fromJson(reader1));
                    continue;
                }
                if ("label".equals(fieldName)) {
                    deserializedConfigServerGitProperty.label = reader.getString();
                    continue;
                }
                if ("searchPaths".equals(fieldName)) {
                    List searchPaths;
                    deserializedConfigServerGitProperty.searchPaths = searchPaths = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedConfigServerGitProperty.username = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedConfigServerGitProperty.password = reader.getString();
                    continue;
                }
                if ("hostKey".equals(fieldName)) {
                    deserializedConfigServerGitProperty.hostKey = reader.getString();
                    continue;
                }
                if ("hostKeyAlgorithm".equals(fieldName)) {
                    deserializedConfigServerGitProperty.hostKeyAlgorithm = reader.getString();
                    continue;
                }
                if ("privateKey".equals(fieldName)) {
                    deserializedConfigServerGitProperty.privateKey = reader.getString();
                    continue;
                }
                if ("strictHostKeyChecking".equals(fieldName)) {
                    deserializedConfigServerGitProperty.strictHostKeyChecking = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConfigServerGitProperty;
        });
    }
}

