/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.ApiPortalApiTryOutEnabledState;
import com.azure.resourcemanager.appplatform.models.ApiPortalInstance;
import com.azure.resourcemanager.appplatform.models.ApiPortalProvisioningState;
import com.azure.resourcemanager.appplatform.models.ApiPortalResourceRequests;
import com.azure.resourcemanager.appplatform.models.SsoProperties;
import java.io.IOException;
import java.util.List;

public final class ApiPortalProperties
implements JsonSerializable<ApiPortalProperties> {
    private ApiPortalProvisioningState provisioningState;
    private Boolean publicProperty;
    private String url;
    private Boolean httpsOnly;
    private List<String> gatewayIds;
    private List<String> sourceUrls;
    private SsoProperties ssoProperties;
    private ApiPortalResourceRequests resourceRequests;
    private List<ApiPortalInstance> instances;
    private ApiPortalApiTryOutEnabledState apiTryOutEnabledState;

    public ApiPortalProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Boolean publicProperty() {
        return this.publicProperty;
    }

    public ApiPortalProperties withPublicProperty(Boolean publicProperty) {
        this.publicProperty = publicProperty;
        return this;
    }

    public String url() {
        return this.url;
    }

    public Boolean httpsOnly() {
        return this.httpsOnly;
    }

    public ApiPortalProperties withHttpsOnly(Boolean httpsOnly) {
        this.httpsOnly = httpsOnly;
        return this;
    }

    public List<String> gatewayIds() {
        return this.gatewayIds;
    }

    public ApiPortalProperties withGatewayIds(List<String> gatewayIds) {
        this.gatewayIds = gatewayIds;
        return this;
    }

    public List<String> sourceUrls() {
        return this.sourceUrls;
    }

    public ApiPortalProperties withSourceUrls(List<String> sourceUrls) {
        this.sourceUrls = sourceUrls;
        return this;
    }

    public SsoProperties ssoProperties() {
        return this.ssoProperties;
    }

    public ApiPortalProperties withSsoProperties(SsoProperties ssoProperties) {
        this.ssoProperties = ssoProperties;
        return this;
    }

    public ApiPortalResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    public List<ApiPortalInstance> instances() {
        return this.instances;
    }

    public ApiPortalApiTryOutEnabledState apiTryOutEnabledState() {
        return this.apiTryOutEnabledState;
    }

    public ApiPortalProperties withApiTryOutEnabledState(ApiPortalApiTryOutEnabledState apiTryOutEnabledState) {
        this.apiTryOutEnabledState = apiTryOutEnabledState;
        return this;
    }

    public void validate() {
        if (this.ssoProperties() != null) {
            this.ssoProperties().validate();
        }
        if (this.resourceRequests() != null) {
            this.resourceRequests().validate();
        }
        if (this.instances() != null) {
            this.instances().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("public", this.publicProperty);
        jsonWriter.writeBooleanField("httpsOnly", this.httpsOnly);
        jsonWriter.writeArrayField("gatewayIds", this.gatewayIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("sourceUrls", this.sourceUrls, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("ssoProperties", (JsonSerializable)this.ssoProperties);
        jsonWriter.writeStringField("apiTryOutEnabledState", this.apiTryOutEnabledState == null ? null : this.apiTryOutEnabledState.toString());
        return jsonWriter.writeEndObject();
    }

    public static ApiPortalProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ApiPortalProperties)jsonReader.readObject(reader -> {
            ApiPortalProperties deserializedApiPortalProperties = new ApiPortalProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedApiPortalProperties.provisioningState = ApiPortalProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("public".equals(fieldName)) {
                    deserializedApiPortalProperties.publicProperty = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedApiPortalProperties.url = reader.getString();
                    continue;
                }
                if ("httpsOnly".equals(fieldName)) {
                    deserializedApiPortalProperties.httpsOnly = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("gatewayIds".equals(fieldName)) {
                    List gatewayIds;
                    deserializedApiPortalProperties.gatewayIds = gatewayIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("sourceUrls".equals(fieldName)) {
                    List sourceUrls;
                    deserializedApiPortalProperties.sourceUrls = sourceUrls = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("ssoProperties".equals(fieldName)) {
                    deserializedApiPortalProperties.ssoProperties = SsoProperties.fromJson(reader);
                    continue;
                }
                if ("resourceRequests".equals(fieldName)) {
                    deserializedApiPortalProperties.resourceRequests = ApiPortalResourceRequests.fromJson(reader);
                    continue;
                }
                if ("instances".equals(fieldName)) {
                    List instances;
                    deserializedApiPortalProperties.instances = instances = reader.readArray(reader1 -> ApiPortalInstance.fromJson(reader1));
                    continue;
                }
                if ("apiTryOutEnabledState".equals(fieldName)) {
                    deserializedApiPortalProperties.apiTryOutEnabledState = ApiPortalApiTryOutEnabledState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiPortalProperties;
        });
    }
}

