/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.CustomContainer;
import com.azure.resourcemanager.appplatform.models.UserSourceInfo;
import java.io.IOException;

public final class CustomContainerUserSourceInfo
extends UserSourceInfo {
    private String type = "Container";
    private CustomContainer customContainer;

    @Override
    public String type() {
        return this.type;
    }

    public CustomContainer customContainer() {
        return this.customContainer;
    }

    public CustomContainerUserSourceInfo withCustomContainer(CustomContainer customContainer) {
        this.customContainer = customContainer;
        return this;
    }

    @Override
    public CustomContainerUserSourceInfo withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.customContainer() != null) {
            this.customContainer().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("customContainer", (JsonSerializable)this.customContainer);
        return jsonWriter.writeEndObject();
    }

    public static CustomContainerUserSourceInfo fromJson(JsonReader jsonReader) throws IOException {
        return (CustomContainerUserSourceInfo)jsonReader.readObject(reader -> {
            CustomContainerUserSourceInfo deserializedCustomContainerUserSourceInfo = new CustomContainerUserSourceInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedCustomContainerUserSourceInfo.withVersion(reader.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCustomContainerUserSourceInfo.type = reader.getString();
                    continue;
                }
                if ("customContainer".equals(fieldName)) {
                    deserializedCustomContainerUserSourceInfo.customContainer = CustomContainer.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomContainerUserSourceInfo;
        });
    }
}

