/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.AppResourceProperties;
import com.azure.resourcemanager.appplatform.models.ManagedIdentityProperties;
import java.io.IOException;

public final class AppResourceInner
extends ProxyResource {
    private AppResourceProperties properties;
    private ManagedIdentityProperties identity;
    private String location;
    private SystemData systemData;
    private String id;
    private String name;
    private String type;

    public AppResourceProperties properties() {
        return this.properties;
    }

    public AppResourceInner withProperties(AppResourceProperties properties) {
        this.properties = properties;
        return this;
    }

    public ManagedIdentityProperties identity() {
        return this.identity;
    }

    public AppResourceInner withIdentity(ManagedIdentityProperties identity) {
        this.identity = identity;
        return this;
    }

    public String location() {
        return this.location;
    }

    public AppResourceInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeStringField("location", this.location);
        return jsonWriter.writeEndObject();
    }

    public static AppResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (AppResourceInner)((Object)jsonReader.readObject(reader -> {
            AppResourceInner deserializedAppResourceInner = new AppResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAppResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAppResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAppResourceInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAppResourceInner.properties = AppResourceProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedAppResourceInner.identity = ManagedIdentityProperties.fromJson(reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedAppResourceInner.location = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedAppResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAppResourceInner;
        }));
    }
}

