/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.DevToolPortalComponent;
import com.azure.resourcemanager.appplatform.models.DevToolPortalFeatureSettings;
import com.azure.resourcemanager.appplatform.models.DevToolPortalProvisioningState;
import com.azure.resourcemanager.appplatform.models.DevToolPortalSsoProperties;
import java.io.IOException;
import java.util.List;

public final class DevToolPortalProperties
implements JsonSerializable<DevToolPortalProperties> {
    private DevToolPortalProvisioningState provisioningState;
    private List<DevToolPortalComponent> components;
    private Boolean publicProperty;
    private String url;
    private DevToolPortalSsoProperties ssoProperties;
    private DevToolPortalFeatureSettings features;

    public DevToolPortalProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<DevToolPortalComponent> components() {
        return this.components;
    }

    public Boolean publicProperty() {
        return this.publicProperty;
    }

    public DevToolPortalProperties withPublicProperty(Boolean publicProperty) {
        this.publicProperty = publicProperty;
        return this;
    }

    public String url() {
        return this.url;
    }

    public DevToolPortalSsoProperties ssoProperties() {
        return this.ssoProperties;
    }

    public DevToolPortalProperties withSsoProperties(DevToolPortalSsoProperties ssoProperties) {
        this.ssoProperties = ssoProperties;
        return this;
    }

    public DevToolPortalFeatureSettings features() {
        return this.features;
    }

    public DevToolPortalProperties withFeatures(DevToolPortalFeatureSettings features) {
        this.features = features;
        return this;
    }

    public void validate() {
        if (this.components() != null) {
            this.components().forEach(e -> e.validate());
        }
        if (this.ssoProperties() != null) {
            this.ssoProperties().validate();
        }
        if (this.features() != null) {
            this.features().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("public", this.publicProperty);
        jsonWriter.writeJsonField("ssoProperties", (JsonSerializable)this.ssoProperties);
        jsonWriter.writeJsonField("features", (JsonSerializable)this.features);
        return jsonWriter.writeEndObject();
    }

    public static DevToolPortalProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DevToolPortalProperties)jsonReader.readObject(reader -> {
            DevToolPortalProperties deserializedDevToolPortalProperties = new DevToolPortalProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedDevToolPortalProperties.provisioningState = DevToolPortalProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("components".equals(fieldName)) {
                    List components;
                    deserializedDevToolPortalProperties.components = components = reader.readArray(reader1 -> DevToolPortalComponent.fromJson(reader1));
                    continue;
                }
                if ("public".equals(fieldName)) {
                    deserializedDevToolPortalProperties.publicProperty = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedDevToolPortalProperties.url = reader.getString();
                    continue;
                }
                if ("ssoProperties".equals(fieldName)) {
                    deserializedDevToolPortalProperties.ssoProperties = DevToolPortalSsoProperties.fromJson(reader);
                    continue;
                }
                if ("features".equals(fieldName)) {
                    deserializedDevToolPortalProperties.features = DevToolPortalFeatureSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDevToolPortalProperties;
        });
    }
}

