/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.WorkloadProfileStatesInner;
import java.io.IOException;
import java.util.List;

public final class WorkloadProfileStatesCollection
implements JsonSerializable<WorkloadProfileStatesCollection> {
    private List<WorkloadProfileStatesInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(WorkloadProfileStatesCollection.class);

    public List<WorkloadProfileStatesInner> value() {
        return this.value;
    }

    public WorkloadProfileStatesCollection withValue(List<WorkloadProfileStatesInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model WorkloadProfileStatesCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static WorkloadProfileStatesCollection fromJson(JsonReader jsonReader) throws IOException {
        return (WorkloadProfileStatesCollection)jsonReader.readObject(reader -> {
            WorkloadProfileStatesCollection deserializedWorkloadProfileStatesCollection = new WorkloadProfileStatesCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedWorkloadProfileStatesCollection.value = value = reader.readArray(reader1 -> WorkloadProfileStatesInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedWorkloadProfileStatesCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkloadProfileStatesCollection;
        });
    }
}

