/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.WorkflowHealth;
import com.azure.resourcemanager.appcontainers.models.WorkflowState;
import java.io.IOException;

public final class WorkflowEnvelopeProperties
implements JsonSerializable<WorkflowEnvelopeProperties> {
    private Object files;
    private WorkflowState flowState;
    private WorkflowHealth health;

    public Object files() {
        return this.files;
    }

    public WorkflowEnvelopeProperties withFiles(Object files) {
        this.files = files;
        return this;
    }

    public WorkflowState flowState() {
        return this.flowState;
    }

    public WorkflowEnvelopeProperties withFlowState(WorkflowState flowState) {
        this.flowState = flowState;
        return this;
    }

    public WorkflowHealth health() {
        return this.health;
    }

    public WorkflowEnvelopeProperties withHealth(WorkflowHealth health) {
        this.health = health;
        return this;
    }

    public void validate() {
        if (this.health() != null) {
            this.health().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.files != null) {
            jsonWriter.writeUntypedField("files", this.files);
        }
        jsonWriter.writeStringField("flowState", this.flowState == null ? null : this.flowState.toString());
        jsonWriter.writeJsonField("health", (JsonSerializable)this.health);
        return jsonWriter.writeEndObject();
    }

    public static WorkflowEnvelopeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (WorkflowEnvelopeProperties)jsonReader.readObject(reader -> {
            WorkflowEnvelopeProperties deserializedWorkflowEnvelopeProperties = new WorkflowEnvelopeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("files".equals(fieldName)) {
                    deserializedWorkflowEnvelopeProperties.files = reader.readUntyped();
                    continue;
                }
                if ("flowState".equals(fieldName)) {
                    deserializedWorkflowEnvelopeProperties.flowState = WorkflowState.fromString(reader.getString());
                    continue;
                }
                if ("health".equals(fieldName)) {
                    deserializedWorkflowEnvelopeProperties.health = WorkflowHealth.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkflowEnvelopeProperties;
        });
    }
}

