/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class VnetConfiguration
implements JsonSerializable<VnetConfiguration> {
    private Boolean internal;
    private String infrastructureSubnetId;
    private String dockerBridgeCidr;
    private String platformReservedCidr;
    private String platformReservedDnsIp;

    public Boolean internal() {
        return this.internal;
    }

    public VnetConfiguration withInternal(Boolean internal) {
        this.internal = internal;
        return this;
    }

    public String infrastructureSubnetId() {
        return this.infrastructureSubnetId;
    }

    public VnetConfiguration withInfrastructureSubnetId(String infrastructureSubnetId) {
        this.infrastructureSubnetId = infrastructureSubnetId;
        return this;
    }

    public String dockerBridgeCidr() {
        return this.dockerBridgeCidr;
    }

    public VnetConfiguration withDockerBridgeCidr(String dockerBridgeCidr) {
        this.dockerBridgeCidr = dockerBridgeCidr;
        return this;
    }

    public String platformReservedCidr() {
        return this.platformReservedCidr;
    }

    public VnetConfiguration withPlatformReservedCidr(String platformReservedCidr) {
        this.platformReservedCidr = platformReservedCidr;
        return this;
    }

    public String platformReservedDnsIp() {
        return this.platformReservedDnsIp;
    }

    public VnetConfiguration withPlatformReservedDnsIp(String platformReservedDnsIp) {
        this.platformReservedDnsIp = platformReservedDnsIp;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("internal", this.internal);
        jsonWriter.writeStringField("infrastructureSubnetId", this.infrastructureSubnetId);
        jsonWriter.writeStringField("dockerBridgeCidr", this.dockerBridgeCidr);
        jsonWriter.writeStringField("platformReservedCidr", this.platformReservedCidr);
        jsonWriter.writeStringField("platformReservedDnsIP", this.platformReservedDnsIp);
        return jsonWriter.writeEndObject();
    }

    public static VnetConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (VnetConfiguration)jsonReader.readObject(reader -> {
            VnetConfiguration deserializedVnetConfiguration = new VnetConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("internal".equals(fieldName)) {
                    deserializedVnetConfiguration.internal = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("infrastructureSubnetId".equals(fieldName)) {
                    deserializedVnetConfiguration.infrastructureSubnetId = reader.getString();
                    continue;
                }
                if ("dockerBridgeCidr".equals(fieldName)) {
                    deserializedVnetConfiguration.dockerBridgeCidr = reader.getString();
                    continue;
                }
                if ("platformReservedCidr".equals(fieldName)) {
                    deserializedVnetConfiguration.platformReservedCidr = reader.getString();
                    continue;
                }
                if ("platformReservedDnsIP".equals(fieldName)) {
                    deserializedVnetConfiguration.platformReservedDnsIp = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVnetConfiguration;
        });
    }
}

