/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.BlobStorageTokenStore;
import java.io.IOException;

public final class TokenStore
implements JsonSerializable<TokenStore> {
    private Boolean enabled;
    private Double tokenRefreshExtensionHours;
    private BlobStorageTokenStore azureBlobStorage;

    public Boolean enabled() {
        return this.enabled;
    }

    public TokenStore withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Double tokenRefreshExtensionHours() {
        return this.tokenRefreshExtensionHours;
    }

    public TokenStore withTokenRefreshExtensionHours(Double tokenRefreshExtensionHours) {
        this.tokenRefreshExtensionHours = tokenRefreshExtensionHours;
        return this;
    }

    public BlobStorageTokenStore azureBlobStorage() {
        return this.azureBlobStorage;
    }

    public TokenStore withAzureBlobStorage(BlobStorageTokenStore azureBlobStorage) {
        this.azureBlobStorage = azureBlobStorage;
        return this;
    }

    public void validate() {
        if (this.azureBlobStorage() != null) {
            this.azureBlobStorage().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeNumberField("tokenRefreshExtensionHours", (Number)this.tokenRefreshExtensionHours);
        jsonWriter.writeJsonField("azureBlobStorage", (JsonSerializable)this.azureBlobStorage);
        return jsonWriter.writeEndObject();
    }

    public static TokenStore fromJson(JsonReader jsonReader) throws IOException {
        return (TokenStore)jsonReader.readObject(reader -> {
            TokenStore deserializedTokenStore = new TokenStore();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedTokenStore.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("tokenRefreshExtensionHours".equals(fieldName)) {
                    deserializedTokenStore.tokenRefreshExtensionHours = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("azureBlobStorage".equals(fieldName)) {
                    deserializedTokenStore.azureBlobStorage = BlobStorageTokenStore.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTokenStore;
        });
    }
}

