/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.SourceControlInner;
import com.azure.resourcemanager.appcontainers.models.GithubActionConfiguration;
import com.azure.resourcemanager.appcontainers.models.SourceControlOperationState;

public interface SourceControl {
    public String id();

    public String name();

    public String type();

    public SystemData systemData();

    public SourceControlOperationState operationState();

    public String repoUrl();

    public String branch();

    public GithubActionConfiguration githubActionConfiguration();

    public String resourceGroupName();

    public SourceControlInner innerModel();

    public Update update();

    public SourceControl refresh();

    public SourceControl refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithGithubActionConfiguration {
            public Update withGithubActionConfiguration(GithubActionConfiguration var1);
        }

        public static interface WithBranch {
            public Update withBranch(String var1);
        }

        public static interface WithRepoUrl {
            public Update withRepoUrl(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithRepoUrl,
    UpdateStages.WithBranch,
    UpdateStages.WithGithubActionConfiguration {
        public SourceControl apply();

        public SourceControl apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithGithubActionConfiguration {
            public WithCreate withGithubActionConfiguration(GithubActionConfiguration var1);
        }

        public static interface WithBranch {
            public WithCreate withBranch(String var1);
        }

        public static interface WithRepoUrl {
            public WithCreate withRepoUrl(String var1);
        }

        public static interface WithCreate
        extends WithRepoUrl,
        WithBranch,
        WithGithubActionConfiguration {
            public SourceControl create();

            public SourceControl create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingContainerApp(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

