/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class OpenIdConnectConfig
implements JsonSerializable<OpenIdConnectConfig> {
    private String authorizationEndpoint;
    private String tokenEndpoint;
    private String issuer;
    private String certificationUri;
    private String wellKnownOpenIdConfiguration;

    public String authorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public OpenIdConnectConfig withAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
        return this;
    }

    public String tokenEndpoint() {
        return this.tokenEndpoint;
    }

    public OpenIdConnectConfig withTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
        return this;
    }

    public String issuer() {
        return this.issuer;
    }

    public OpenIdConnectConfig withIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public String certificationUri() {
        return this.certificationUri;
    }

    public OpenIdConnectConfig withCertificationUri(String certificationUri) {
        this.certificationUri = certificationUri;
        return this;
    }

    public String wellKnownOpenIdConfiguration() {
        return this.wellKnownOpenIdConfiguration;
    }

    public OpenIdConnectConfig withWellKnownOpenIdConfiguration(String wellKnownOpenIdConfiguration) {
        this.wellKnownOpenIdConfiguration = wellKnownOpenIdConfiguration;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("authorizationEndpoint", this.authorizationEndpoint);
        jsonWriter.writeStringField("tokenEndpoint", this.tokenEndpoint);
        jsonWriter.writeStringField("issuer", this.issuer);
        jsonWriter.writeStringField("certificationUri", this.certificationUri);
        jsonWriter.writeStringField("wellKnownOpenIdConfiguration", this.wellKnownOpenIdConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static OpenIdConnectConfig fromJson(JsonReader jsonReader) throws IOException {
        return (OpenIdConnectConfig)jsonReader.readObject(reader -> {
            OpenIdConnectConfig deserializedOpenIdConnectConfig = new OpenIdConnectConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("authorizationEndpoint".equals(fieldName)) {
                    deserializedOpenIdConnectConfig.authorizationEndpoint = reader.getString();
                    continue;
                }
                if ("tokenEndpoint".equals(fieldName)) {
                    deserializedOpenIdConnectConfig.tokenEndpoint = reader.getString();
                    continue;
                }
                if ("issuer".equals(fieldName)) {
                    deserializedOpenIdConnectConfig.issuer = reader.getString();
                    continue;
                }
                if ("certificationUri".equals(fieldName)) {
                    deserializedOpenIdConnectConfig.certificationUri = reader.getString();
                    continue;
                }
                if ("wellKnownOpenIdConfiguration".equals(fieldName)) {
                    deserializedOpenIdConnectConfig.wellKnownOpenIdConfiguration = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOpenIdConnectConfig;
        });
    }
}

