/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.Container;
import com.azure.resourcemanager.appcontainers.models.InitContainer;
import com.azure.resourcemanager.appcontainers.models.Volume;
import java.io.IOException;
import java.util.List;

public final class JobTemplate
implements JsonSerializable<JobTemplate> {
    private List<InitContainer> initContainers;
    private List<Container> containers;
    private List<Volume> volumes;

    public List<InitContainer> initContainers() {
        return this.initContainers;
    }

    public JobTemplate withInitContainers(List<InitContainer> initContainers) {
        this.initContainers = initContainers;
        return this;
    }

    public List<Container> containers() {
        return this.containers;
    }

    public JobTemplate withContainers(List<Container> containers) {
        this.containers = containers;
        return this;
    }

    public List<Volume> volumes() {
        return this.volumes;
    }

    public JobTemplate withVolumes(List<Volume> volumes) {
        this.volumes = volumes;
        return this;
    }

    public void validate() {
        if (this.initContainers() != null) {
            this.initContainers().forEach(e -> e.validate());
        }
        if (this.containers() != null) {
            this.containers().forEach(e -> e.validate());
        }
        if (this.volumes() != null) {
            this.volumes().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("initContainers", this.initContainers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("containers", this.containers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("volumes", this.volumes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static JobTemplate fromJson(JsonReader jsonReader) throws IOException {
        return (JobTemplate)jsonReader.readObject(reader -> {
            JobTemplate deserializedJobTemplate = new JobTemplate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("initContainers".equals(fieldName)) {
                    List initContainers;
                    deserializedJobTemplate.initContainers = initContainers = reader.readArray(reader1 -> InitContainer.fromJson(reader1));
                    continue;
                }
                if ("containers".equals(fieldName)) {
                    List containers;
                    deserializedJobTemplate.containers = containers = reader.readArray(reader1 -> Container.fromJson(reader1));
                    continue;
                }
                if ("volumes".equals(fieldName)) {
                    List volumes;
                    deserializedJobTemplate.volumes = volumes = reader.readArray(reader1 -> Volume.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobTemplate;
        });
    }
}

