/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.JobScale;
import java.io.IOException;

public final class JobConfigurationEventTriggerConfig
implements JsonSerializable<JobConfigurationEventTriggerConfig> {
    private Integer replicaCompletionCount;
    private Integer parallelism;
    private JobScale scale;

    public Integer replicaCompletionCount() {
        return this.replicaCompletionCount;
    }

    public JobConfigurationEventTriggerConfig withReplicaCompletionCount(Integer replicaCompletionCount) {
        this.replicaCompletionCount = replicaCompletionCount;
        return this;
    }

    public Integer parallelism() {
        return this.parallelism;
    }

    public JobConfigurationEventTriggerConfig withParallelism(Integer parallelism) {
        this.parallelism = parallelism;
        return this;
    }

    public JobScale scale() {
        return this.scale;
    }

    public JobConfigurationEventTriggerConfig withScale(JobScale scale) {
        this.scale = scale;
        return this;
    }

    public void validate() {
        if (this.scale() != null) {
            this.scale().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("replicaCompletionCount", (Number)this.replicaCompletionCount);
        jsonWriter.writeNumberField("parallelism", (Number)this.parallelism);
        jsonWriter.writeJsonField("scale", (JsonSerializable)this.scale);
        return jsonWriter.writeEndObject();
    }

    public static JobConfigurationEventTriggerConfig fromJson(JsonReader jsonReader) throws IOException {
        return (JobConfigurationEventTriggerConfig)jsonReader.readObject(reader -> {
            JobConfigurationEventTriggerConfig deserializedJobConfigurationEventTriggerConfig = new JobConfigurationEventTriggerConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("replicaCompletionCount".equals(fieldName)) {
                    deserializedJobConfigurationEventTriggerConfig.replicaCompletionCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("parallelism".equals(fieldName)) {
                    deserializedJobConfigurationEventTriggerConfig.parallelism = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("scale".equals(fieldName)) {
                    deserializedJobConfigurationEventTriggerConfig.scale = JobScale.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobConfigurationEventTriggerConfig;
        });
    }
}

