/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.JobInner;
import com.azure.resourcemanager.appcontainers.models.ContainerAppJobExecutions;
import com.azure.resourcemanager.appcontainers.models.JobConfiguration;
import com.azure.resourcemanager.appcontainers.models.JobExecutionBase;
import com.azure.resourcemanager.appcontainers.models.JobExecutionTemplate;
import com.azure.resourcemanager.appcontainers.models.JobPatchPropertiesProperties;
import com.azure.resourcemanager.appcontainers.models.JobProvisioningState;
import com.azure.resourcemanager.appcontainers.models.JobSecretsCollection;
import com.azure.resourcemanager.appcontainers.models.JobTemplate;
import com.azure.resourcemanager.appcontainers.models.ManagedServiceIdentity;
import java.util.List;
import java.util.Map;

public interface Job {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public ManagedServiceIdentity identity();

    public SystemData systemData();

    public JobProvisioningState provisioningState();

    public String environmentId();

    public String workloadProfileName();

    public JobConfiguration configuration();

    public JobTemplate template();

    public List<String> outboundIpAddresses();

    public String eventStreamEndpoint();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public JobInner innerModel();

    public Update update();

    public Job refresh();

    public Job refresh(Context var1);

    public JobExecutionBase start();

    public JobExecutionBase start(JobExecutionTemplate var1, Context var2);

    public ContainerAppJobExecutions stopMultipleExecutions();

    public ContainerAppJobExecutions stopMultipleExecutions(Context var1);

    public Response<JobSecretsCollection> listSecretsWithResponse(Context var1);

    public JobSecretsCollection listSecrets();

    public static interface UpdateStages {

        public static interface WithProperties {
            public Update withProperties(JobPatchPropertiesProperties var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIdentity,
    UpdateStages.WithProperties {
        public Job apply();

        public Job apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithTemplate {
            public WithCreate withTemplate(JobTemplate var1);
        }

        public static interface WithConfiguration {
            public WithCreate withConfiguration(JobConfiguration var1);
        }

        public static interface WithWorkloadProfileName {
            public WithCreate withWorkloadProfileName(String var1);
        }

        public static interface WithEnvironmentId {
            public WithCreate withEnvironmentId(String var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithIdentity,
        WithEnvironmentId,
        WithWorkloadProfileName,
        WithConfiguration,
        WithTemplate {
            public Job create();

            public Job create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

