/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.JavaComponentInner;
import java.io.IOException;
import java.util.List;

public final class JavaComponentsCollection
implements JsonSerializable<JavaComponentsCollection> {
    private List<JavaComponentInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(JavaComponentsCollection.class);

    public List<JavaComponentInner> value() {
        return this.value;
    }

    public JavaComponentsCollection withValue(List<JavaComponentInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model JavaComponentsCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static JavaComponentsCollection fromJson(JsonReader jsonReader) throws IOException {
        return (JavaComponentsCollection)jsonReader.readObject(reader -> {
            JavaComponentsCollection deserializedJavaComponentsCollection = new JavaComponentsCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedJavaComponentsCollection.value = value = reader.readArray(reader1 -> JavaComponentInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedJavaComponentsCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJavaComponentsCollection;
        });
    }
}

