/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.IdentitySettingsLifeCycle;
import java.io.IOException;

public final class IdentitySettings
implements JsonSerializable<IdentitySettings> {
    private String identity;
    private IdentitySettingsLifeCycle lifecycle;
    private static final ClientLogger LOGGER = new ClientLogger(IdentitySettings.class);

    public String identity() {
        return this.identity;
    }

    public IdentitySettings withIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    public IdentitySettingsLifeCycle lifecycle() {
        return this.lifecycle;
    }

    public IdentitySettings withLifecycle(IdentitySettingsLifeCycle lifecycle) {
        this.lifecycle = lifecycle;
        return this;
    }

    public void validate() {
        if (this.identity() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property identity in model IdentitySettings"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("identity", this.identity);
        jsonWriter.writeStringField("lifecycle", this.lifecycle == null ? null : this.lifecycle.toString());
        return jsonWriter.writeEndObject();
    }

    public static IdentitySettings fromJson(JsonReader jsonReader) throws IOException {
        return (IdentitySettings)jsonReader.readObject(reader -> {
            IdentitySettings deserializedIdentitySettings = new IdentitySettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("identity".equals(fieldName)) {
                    deserializedIdentitySettings.identity = reader.getString();
                    continue;
                }
                if ("lifecycle".equals(fieldName)) {
                    deserializedIdentitySettings.lifecycle = IdentitySettingsLifeCycle.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIdentitySettings;
        });
    }
}

