/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.ForwardProxyConvention;
import java.io.IOException;

public final class ForwardProxy
implements JsonSerializable<ForwardProxy> {
    private ForwardProxyConvention convention;
    private String customHostHeaderName;
    private String customProtoHeaderName;

    public ForwardProxyConvention convention() {
        return this.convention;
    }

    public ForwardProxy withConvention(ForwardProxyConvention convention) {
        this.convention = convention;
        return this;
    }

    public String customHostHeaderName() {
        return this.customHostHeaderName;
    }

    public ForwardProxy withCustomHostHeaderName(String customHostHeaderName) {
        this.customHostHeaderName = customHostHeaderName;
        return this;
    }

    public String customProtoHeaderName() {
        return this.customProtoHeaderName;
    }

    public ForwardProxy withCustomProtoHeaderName(String customProtoHeaderName) {
        this.customProtoHeaderName = customProtoHeaderName;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("convention", this.convention == null ? null : this.convention.toString());
        jsonWriter.writeStringField("customHostHeaderName", this.customHostHeaderName);
        jsonWriter.writeStringField("customProtoHeaderName", this.customProtoHeaderName);
        return jsonWriter.writeEndObject();
    }

    public static ForwardProxy fromJson(JsonReader jsonReader) throws IOException {
        return (ForwardProxy)jsonReader.readObject(reader -> {
            ForwardProxy deserializedForwardProxy = new ForwardProxy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("convention".equals(fieldName)) {
                    deserializedForwardProxy.convention = ForwardProxyConvention.fromString(reader.getString());
                    continue;
                }
                if ("customHostHeaderName".equals(fieldName)) {
                    deserializedForwardProxy.customHostHeaderName = reader.getString();
                    continue;
                }
                if ("customProtoHeaderName".equals(fieldName)) {
                    deserializedForwardProxy.customProtoHeaderName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedForwardProxy;
        });
    }
}

